<?php

ini_set('display_errors' , 0);
// error_reporting(E_ALL);
class UBY_MANAGER extends UBY_TUNINGFILES_CATALOG_PLUGIN 
{
    
    

    public function __construct()
    {


    	add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_filter('set-screen-option', [ __CLASS__, 'set_screen' ], 10, 3 );

        

        add_action( 'init', array( $this, 'rewrite' ) );
        add_filter( 'query_vars', array( $this, 'query_vars' ) );
        add_action( 'template_include', array( $this, 'change_template' ) );

       // $plugin_data = get_plugin_data( __FILE__ );
        wp_enqueue_script( 'mf_adminJS', get_site_url().'/wp-content/plugins/tuningfilescatalog/assets/admin/script.js'  , array('jquery') );
        wp_enqueue_script( 'jquery_ui', 'https://code.jquery.com/ui/1.12.1/jquery-ui.min.js'  , array('jquery') );
         
        add_action('wp_ajax_nopriv_edit_vehicule_value', array( $this, 'edit_vehicule_value') );
        add_action('wp_ajax_edit_vehicule_value', array( $this, 'edit_vehicule_value'));
    
        add_action('wp_ajax_nopriv_reset_vehicule_value', array( $this, 'reset_vehicule_value') );
        add_action('wp_ajax_reset_vehicule_value', array( $this, 'reset_vehicule_value'));
        
        add_action('wp_ajax_nopriv_filterListManager', array( $this, 'filterListManager') );
        add_action('wp_ajax_filterListManager', array( $this, 'filterListManager'));
        
        add_action('wp_ajax_nopriv_publish_vehicule', array( $this, 'publish_vehicule') );
        add_action('wp_ajax_publish_vehicule', array( $this, 'publish_vehicule'));
        
        add_action('wp_ajax_nopriv_set_pricing_rule', array( $this, 'set_pricing_rule') );
        add_action('wp_ajax_set_pricing_rule', array( $this, 'set_pricing_rule'));
        
        add_action('wp_ajax_nopriv_enable_pricing_rule', array( $this, 'enable_pricing_rule') );
        add_action('wp_ajax_enable_pricing_rule', array( $this, 'enable_pricing_rule'));
        
        add_action('wp_ajax_nopriv_change_priority_pricing_rule', array( $this, 'change_priority_pricing_rule') );
        add_action('wp_ajax_change_priority_pricing_rule', array( $this, 'change_priority_pricing_rule'));
    
        add_action('wp_ajax_nopriv_delete_pricing_rule', array( $this, 'delete_pricing_rule') );
        add_action('wp_ajax_delete_pricing_rule', array( $this, 'delete_pricing_rule'));
    
    }

    
    function rewrite() {
         
        
        add_rewrite_rule( '^tuning-files-catalog$', 'index.php?tfc=1', 'top' );
        
        add_rewrite_rule( '^tuning-files-catalog/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)?$', 
                          'index.php?tfc=1&vehicule_type=$matches[1]&mark=$matches[2]&model=$matches[3]&_year=$matches[4]&engine=$matches[5]&hpower=$matches[6]&power=$matches[7]', 
                          'top' );
        add_rewrite_rule( '^tuning-files-catalog/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)?$', 
                          'index.php?tfc=1&vehicule_type=$matches[1]&mark=$matches[2]&model=$matches[3]&_year=$matches[4]', 
                          'top' );
        add_rewrite_rule( '^tuning-files-catalog/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)?$', 
                          'index.php?tfc=1&vehicule_type=$matches[1]&mark=$matches[2]&model=$matches[3]', 
                          'top' );
        add_rewrite_rule( '^tuning-files-catalog/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/?$', 
                          'index.php?tfc=1&vehicule_type=$matches[1]&mark=$matches[2]', 
                          'top' );
        add_rewrite_rule( '^tuning-files-catalog/([a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*)/?', 'index.php?tfc=1&vehicule_type=$matches[1]', 'top' );
        
       


        if(get_transient( 'vpt_flush' )) {
            delete_transient( 'vpt_flush' );
            flush_rewrite_rules();
        }
    }

    function query_vars($vars) {
        $vars[] = 'tfc';
        $vars[] = 'vehicule_type';
        $vars[] = 'mark';
        $vars[] = 'model';
        $vars[] = '_year';
        $vars[] = 'engine';
        $vars[] = 'hpower';
        $vars[] = 'power';
     
         
         

        return $vars;
    }

    function change_template( $template ) {

        
        
        if( get_query_var( 'tfc', false ) !== false  ) {  

            $newTemplate = locate_template( array( 'template-tfc.php' ) );
            if( '' != $newTemplate )
                return $newTemplate;

            //Check plugin directory next
            $newTemplate = plugin_dir_path( __FILE__ ) . 'templates/template-tfc.php';
            if( file_exists( $newTemplate ) )
                return $newTemplate;

        }  

    
        //Fall back to original template
        return $template;
    }

    public static function set_screen( $status, $option, $value ){
        return $value;
    }
     /**
     * add_admin_menu
     * 
     * @access public
     *
     * @return mixed Value.
     */
    public function add_admin_menu()
    {
        $hook = add_menu_page(
            'Mod-files Catalog', 
            'Mod-files Catalog', 
            'manage_options', 
            '__tuningfiles_catalog', 
            array($this, 'set_content_setting'));

        add_action('load-'.$hook, array($this, '_submit_setting'));
        // add sub menus : 
        add_submenu_page(
            '__tuningfiles_catalog',
            'Vehicle management',
            'Vehicle management',
            'manage_options',
            '__tuningfiles_vehicules-manager', 
            array($this, 'set_content_vehicules_manager'));
        // add sub menus : 
        add_submenu_page(
            '__tuningfiles_catalog',
            'Pricing rules',
            'Pricing rules',
            'manage_options',
            '__tuningfiles_pricing-rules', 
            array($this, 'set_content_pricing_rules'));
        // add sub menus : 
        add_submenu_page(
            '__tuningfiles_pricing-rules',
            'New Pricing Rule',
            'New Pricing Rule',
            'manage_options',
            '__tuningfiles_pricing-rules_form', 
            array($this, 'set_content_form_add_new_pricing_rule'));
    }

    /////////////////////////////////////////////////////// 
    // GENERAL SETTINGS  ////////////////////////////////// 
    /////////////////////////////////////////////////////// 
    public function set_content_setting(){
        global $wpdb;    
        // Initialisation 
        // Init Fields form array
        $options_lang = array(
            array( 'id_option' =>'en' , 'name' => "English (United States)" ),
            array( 'id_option' =>'fr' , 'name' => "Français (France)" ),
            array( 'id_option' =>'es' , 'name' => "Español (España)" ),
            array( 'id_option' =>'ru' , 'name' => "русский (Россия)" ),
            array( 'id_option' =>'pt' , 'name' => "Português (Brasil)" ),
            array( 'id_option' =>'it' , 'name' => "Italiano (Italia)" ),
            array( 'id_option' =>'de' , 'name' => "Deutsche (Deutschland)" ),
          
        );


        
        $catalogData = null;
        $catalogData = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}tuningfiles_catalog WHERE id=1" , ARRAY_A  );


        $catalogDispatcher = new UBY_catalog_dispatcher(array() , array());
        // Get vehicule type list : 
        $vehicule_typeList = $catalogDispatcher->tfc_getVechileTypes();

        $displayedVehiculeTypes = json_decode($catalogData['displayed_vehicules_types'],true);
        

         
        ?><h1 style="margin-top: 10px;font-size: 16px;background: #de0d0d;color: white;margin-right: 20px;line-height: 40px;padding: 2px 15px;border-radius: 4px 0 0 4px;text-align: end;">Mod-files TuningFiles Catalog Setting</h1>
        <form class='mar-plugin-form' method="post" action="" enctype="multipart/form-data" style="background: white;padding: 20px;border: 1px solid #ddd;margin-right: 20px;border-radius: 4px;">
           <style>.field-sd {margin-bottom: 6px;}</style> 
            <div class="col">
                <div class="field-sd">
                    <label style="    width: 130px;display: inline-block;font-weight: 600;">Company name</label>
                    <input type="text" name="company_name" placeholder="Company name" value="<?php echo (isset($catalogData['company_name'])) ? ($catalogData['company_name']) :  '';?>"  />
                </div>
                <div class="field-sd">
                    <label  style="width: 100%;display: inline-block; font-weight: 600;">Catalog name <span style="font-weight: 600;font-size: 11px;">We have replace tuning files word with your catalog name</span></label>
                    <input type="text" name="catalog_name" placeholder="Example: Reprogrammation" style="min-width: 200px;" value="<?php echo (isset($catalogData['catalog_name'])) ? ($catalogData['catalog_name']) : '';?>"  />
                </div>
                <fieldset style="padding: 20px 20px;margin: 10px 0;border-top: 1px dashed #ddd;background: #f5f5f5; border-radius: 3px;">
                    <legend style="background: white;padding: 4px 20px;border-radius: 4px;font-weight: 600;color: #de0d0d;">Plugin authentication</legend>
                    <div class="field-sd">
                        <label  style="    width: 130px;display: inline-block;font-weight: 600;">Api Key</label>
                        <input type="text" name="api_key" placeholder="Api Key" value="<?php echo (isset($catalogData['api_key'])) ? ($catalogData['api_key']) : '';?>" />
                    </div>
                    <div class="field-sd">
                        <label  style="    width: 130px;display: inline-block;font-weight: 600;">Api Secret</label>
                        <input type="text" name="api_secret" placeholder="Api Secret" style="    width: 300px;" value="<?php echo (isset($catalogData['api_secret'])) ? ($catalogData['api_secret']) : '';?>" />
                    </div>
                </fieldset>
                <fieldset style="padding: 20px 20px;margin: 10px 0;border-top: 1px dashed #ddd;background: #f5f5f5; border-radius: 3px;">
                    <legend style="background: white;padding: 4px 20px;border-radius: 4px;font-weight: 600;color: #0073aa;">Plugin personalisation</legend>
                    <div class="field-sd">
                        <label  style="    width: 130px;display: inline-block;font-weight: 600;">Display Language</label>
                        <select name="display_lang" id="display_lang"><?php 
                            foreach ( $options_lang as $key => $value) : ?>
                            <option value="<?php echo $value['id_option'] ?>"  <?php 
                            if (isset($catalogData['display_lang']) AND $catalogData['display_lang']!='' AND $catalogData['display_lang']==$value['id_option'] ) echo 'selected';
                             ?>><?php echo $value['name'] ?></option>        
                            <?php endforeach ?>
                        </select>
                    </div>
                    <div class="field-sd">
                        <label  style="    width: 130px;display: inline-block;font-weight: 600;">Display Width</label>
                        <select name="display_width" id="display_width">
                            <option value="full_width_theme"  <?php  if (isset($catalogData['display_width']) AND $catalogData['display_width']!='' AND $catalogData['display_width']=='full_width_theme' ) echo 'selected';?>>Full theme width</option>        
                            <option value="boxed_width_theme"  <?php  if (isset($catalogData['display_width']) AND $catalogData['display_width']!='' AND $catalogData['display_width']=='boxed_width_theme' ) echo 'selected';?>>Boxed width - Max width 990px</option>        
                        </select>
                    </div>
                    <div class="field-sd">
                        <label  style="width: 130px;display: inline-block;font-weight: 600;">Currency code</label>
                        <select name="currency_code" id="currency_code">
                            <?php foreach ($this->currency_codes as $key => $value): ?>
                                <option value="<?php echo $key ?>" <?php echo (isset($catalogData['currency_code']) AND $catalogData['currency_code']==$key) ? 'selected' : '' ?> ><?php  echo $value['name']."( ".$value['symbol']." )" ?></option>
                            <?php endforeach;?>
                        </select>
                    </div>
                    <div class="field-sd">
                        <label  style="    width: 130px;display: inline-block;font-weight: 600;">Background Color</label>
                        <input type="color" name="style_background_color" placeholder="Background Color" value="<?php echo (isset($catalogData['style_background_color'])) ? ($catalogData['style_background_color']) : '';?>"  />
                    </div>
                    <div class="field-sd">
                        <label  style="    width: 130px;display: inline-block;font-weight: 600;">Font Color</label>
                        <input type="color" name="style_font_color"   value="<?php echo (isset($catalogData['style_font_color'])) ? ($catalogData['style_font_color']) : '';?>"  />
                    </div>
                    <div class="field-sd">
                        <label  style="    width: 100%;display: inline-block; font-weight: 600;">Top margin <span style="font-weight: 600;font-size: 11px;">Determine distance from the top of a plugin display to top of window</span></label>
                        <input type="text" name="style_margin_top" placeholder="Example: 100" value="<?php echo (isset($catalogData['style_margin_top'])) ? ($catalogData['style_margin_top']) : '';?>"  />px
                    </div>
                    <div class="field-sd">
                        <label  style="width: 100%;display: inline-block; font-weight: 600;">Applied VAT <span style="font-weight: 600;font-size: 11px;">It is applied only when you add a price to a vehicle</span></label>
                        <input type="text" name="tva_payment" placeholder="Example: 22" value="<?php echo (isset($catalogData['tva_payment'])) ? ($catalogData['tva_payment']) : '0 ';?>"  />%
                    </div>
                    <div style="margin: 20px 0;"><b>Options</b></div>
                    <div class="field-sd">
                        <input type="checkbox" style="vertical-align: middle;margin-top: 0px;" name="style_template_display_photo"  id="style_template_display_photo" value="1"  <?php echo (isset($catalogData['style_template_display_photo']) AND $catalogData['style_template_display_photo']==1) ? 'checked' : '';?>   />
                        <label for="style_template_display_photo"  style="display: inline-block;">View a photo of a vehicle</label>
                    </div>
                    <div class="field-sd">
                        <input type="checkbox" style="vertical-align: middle;margin-top: 0px;" name="style_template_display_long_description"  id="style_template_display_long_description" value="1" <?php echo (isset($catalogData['style_template_display_long_description']) AND $catalogData['style_template_display_long_description']==1) ? 'checked' : '';?>   />
                        <label for="style_template_display_long_description"  style="display: inline-block;">View the long description of a vehicle </label>
                    </div>
                    <div class="field-sd">
                        <input type="checkbox" style="vertical-align: middle;margin-top: 0px;" name="style_template_display_chart"  id="style_template_display_chart" value="1"   <?php echo (isset($catalogData['style_template_display_chart']) AND $catalogData['style_template_display_chart']==1) ? 'checked' : '';?>   />
                        <label for="style_template_display_chart"  style="display: inline-block;">Show the chart of a vehicle</label>
                    </div>
                    <div class="field-sd">
                        <input type="checkbox" style="vertical-align: middle;margin-top: 0px;" name="style_template_display_sub_items"  id="style_template_display_sub_items" value="1"  <?php echo (isset($catalogData['style_template_display_sub_items']) AND $catalogData['style_template_display_sub_items']==1) ? 'checked' : '';?>   />
                        <label for="style_template_display_sub_items"  style="display: inline-block;">Display sub-information (at the bottom of the detail page )</label>
                    </div>
                    <div class="field-sd">
                        <input type="checkbox" style="vertical-align: middle;margin-top: 0px;" name="style_template_display_breadcrumb"  id="style_template_display_breadcrumb" value="1"  <?php echo (isset($catalogData['style_template_display_breadcrumb']) AND $catalogData['style_template_display_breadcrumb']==1) ? 'checked' : '';?>   />
                        <label for="style_template_display_breadcrumb"  style="display: inline-block;">Display small menu - navigation scheme - (at the top of the detail page )</label>
                    </div>
                    <div class="field-sd">
                        <input type="checkbox" style="vertical-align: middle;margin-top: 0px;" name="show_vehicles_prices"  id="show_vehicles_prices" value="1"  <?php echo (isset($catalogData['show_vehicles_prices']) AND $catalogData['show_vehicles_prices']==1) ? 'checked' : '';?>   />
                        <label for="show_vehicles_prices"  style="display: inline-block;">Display Vehicle prices</label>
                    </div>
                    <div style="margin: 20px 0;"><b>Displayed Vehicule types</b></div>
                    <?php if (isset($vehicule_typeList) AND !empty($vehicule_typeList['data'])): ?>
                    <?php foreach ($vehicule_typeList['data'] as $vehicule_type_item): ?>
                        <div class="field-sd">
                            <input type="checkbox" style="vertical-align: middle;margin-top: 0px;" name="displayed_vehicules_types[<?php echo $vehicule_type_item['type']['id']; ?>]"  id="display_vtype_<?php echo $vehicule_type_item['type']['id']; ?>" value="1"  <?php echo (isset($vehicule_type_item['type']['id']) AND in_array($vehicule_type_item['type']['id'], $displayedVehiculeTypes)) ? 'checked' : '';?>   />
                            <label for="display_vtype_<?php echo $vehicule_type_item['type']['id']; ?>"  style="display: inline-block;"><?php echo $vehicule_type_item['type']['name']['en']; ?></label>
                        </div>
                    <?php endforeach;?>
                    <?php else:?>
                        <div class="notice notice-error">The feature requires API access, please enter your authentication API!</div>
                    <?php endif;?>
                </fieldset>
                <?php submit_button("Save!"); ?>
            </div>
            <div class="col">
                <h2>Instructions to follow</h2>
                <ol>
                    <li>- Add your <b>API key</b> and <b>API secret</b> and save your configuration, for more information on obtaining your own access to our catalog, please visit our <a href="https://www.mod-files.com/chiptuning-api.php"  target="_blanc">CHIPTUNING DATABASE</a> page.</li>
                    <li>- After the configuration, you can add the custom link <b>( <a href="<?php echo get_site_url() ?>/tuning-files-catalog/" target="_blanc"><?php echo get_site_url() ?>/tuning-files-catalog/</a> )</b> of plugins to your menu .</li>
                </ol>
            </div>

        </form>
        <?php
    }
    public function _submit_setting(){

        global $wpdb;
        $Data = array();
        $Data_tmp = array(
            'company_name',
            'catalog_name',
            'api_key',
            'api_secret',
            'display_lang',
            'display_width',
            'currency_code',
            'style_background_color',
            'style_font_color', 
            'style_margin_top', 
            'tva_payment', 
            'style_template_display_photo', 
            'style_template_display_long_description', 
            'style_template_display_sub_items', 
            'style_template_display_chart',
            'style_template_display_breadcrumb',
            'show_vehicles_prices',
            'displayed_vehicules_types');
        

       

        foreach ($Data_tmp as $key => $value) {
            if (in_array($value, array(
                'style_template_display_photo', 
                'style_template_display_long_description', 
                'style_template_display_sub_items', 
                'style_template_display_chart',
                'style_template_display_breadcrumb',
                'show_vehicles_prices',
                'displayed_vehicules_types'
                ))){

                if ($value=='displayed_vehicules_types'){
                    
                    $dvt_tmp = array();
                    if (isset($_POST[$value]) AND !empty($_POST[$value])):
                        $dvt_tmp = array_keys($_POST[$value]);
                    endif;

                    
                    $Data[$value] = json_encode($dvt_tmp); 
                }else{
                    $Data[$value] = (isset($_POST[$value]) AND $_POST[$value]=='1') ? '1' : '0';
                }
            }else {

                $Data[$value] = (isset($_POST[$value]) AND $_POST[$value]!='') ? $_POST[$value] : null;
            }
        } 
         
        $Data['_time_creation'] = time();

       


        if ($Data['company_name'] AND $Data['api_key'] AND $Data['api_secret']):


            $response = $wpdb->update("{$wpdb->prefix}tuningfiles_catalog", $Data , array('id'=> '1') );
            if ($response )  add_action( 'admin_notices', array($this , 'notice_success_form_saved') );
            return $response ; 
                


        else: add_action( 'admin_notices', array($this , 'notice_error_form_empty_field') );
        endif;

        return false;
    }
    public function notice_success_form_saved(){ 
        ?><div class="notice notice-success is-dismissible"><p><?php _e( "Settings updated!" , 'sample-text-domain' ); ?></p></div><?php
    }
    public function notice_error_form_empty_field(){ 
        ?><div class="notice notice-warning is-dismissible"><p><?php _e( "Vous devez compléter tous les champs obligatoire!" , 'sample-text-domain' ); ?></p></div><?php
    }
    //////////////////////////////////////////////////////
    // VEHICULES MANAGER /////////////////////////////////
    //////////////////////////////////////////////////////
    public function set_content_vehicules_manager(){
        global $wpdb;    
        // Initialisation 
        // Init Fields form array
        //// options de pagination
        $numPage        = (isset($_GET['p']) AND $_GET['p']!='' ) ? $_GET['p'] : null;  
        if (!isset($numPage) || $numPage==0) $numPage=1;
        $page           = $numPage;
        $cur_page       = $page;
        $page           -= 1;
        $par_page       = 10;//$parameters['pagination'];
        $start          = $page * $par_page;
        $limitedRequest = $start.",".$par_page;  

        /** @var Filter parameters  */
        $filter__vehicule_types = (isset($_GET['filter__vehicule_types']) AND $_GET['filter__vehicule_types']!='' ) ? $_GET['filter__vehicule_types'] : 'cars';
        $filter__marks          = (isset($_GET['filter__marks']) AND $_GET['filter__marks']!='' ) ? $_GET['filter__marks'] : null;
        $filter__models         = (isset($_GET['filter__models']) AND $_GET['filter__models']!='' ) ? $_GET['filter__models'] : null;
        $filter__years          = (isset($_GET['filter__years']) AND $_GET['filter__years']!='' ) ? $_GET['filter__years'] : null;


        $options_lang = array(
            array( 'id_option' =>'en' , 'name' => "English (United States)" ),
            array( 'id_option' =>'fr' , 'name' => "Français (France)" ),
            array( 'id_option' =>'es' , 'name' => "Español (España)" ),
            array( 'id_option' =>'ru' , 'name' => "русский (Россия)" ),
            array( 'id_option' =>'pt' , 'name' => "Português (Brasil)" ),
            array( 'id_option' =>'it' , 'name' => "Italiano (Italia)" ),
            array( 'id_option' =>'de' , 'name' => "Deutsche (Deutschland)" ),
          
        );
        
        $catalogData = null;
        $catalogData = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}tuningfiles_catalog WHERE id=1" , ARRAY_A  );

        $TVA = $catalogData['tva_payment'];


        require_once "catalog_manager.php";
        $catalogManager = new UBY_catalog_manager();
        $vehicules_args = array(
            'vehicule_type'    => 'cars' ,
            'pagination_index' => $cur_page,
            'pagination_page'  => $par_page ,
        );
        /** Add filter paramters to main seach  */
        if(isset($filter__vehicule_types) AND $filter__vehicule_types!='') $vehicules_args['vehicule_type'] =$filter__vehicule_types;
        if(isset($filter__marks) AND $filter__marks!='') $vehicules_args['mark'] =$filter__marks;
        if(isset($filter__models) AND $filter__models!='') $vehicules_args['model'] =$filter__models;
        if(isset($filter__years) AND $filter__years!='') $vehicules_args['year'] =$filter__years;
        

        $vehiculesList = $catalogManager->get($vehicules_args);
        
        // All vehicules :
        $vehicules_args['pagination_page'] = '';    
        $vehiculesList__all = $catalogManager->get($vehicules_args);    
        $plugin_data = get_plugin_data( __FILE__ );

        $catalogDispatcher = new UBY_catalog_dispatcher(array() , array());
        // Get vehicule type list : 
        $vehicule_typeList = $catalogDispatcher->tfc_getVechileTypes();
        // Get mark list : 
        $marksList = $catalogDispatcher->sbs_getMarks(array(
            'vehicule_type' => $filter__vehicule_types
        ));
        // Get model list 
        if (isset($filter__vehicule_types) AND isset($filter__marks)):
            $modelsList = $catalogDispatcher->sbs_getModels(array(
                'vehicule_type' => $filter__vehicule_types,
                'mark' => $filter__marks
          ));
        endif;
         // Get construction years list 
        if (isset($filter__vehicule_types) AND  isset($filter__marks) AND isset($filter__models) AND isset($filter__years)):
            $yearsList = $catalogDispatcher->sbs_getProductionYear(array(
                'vehicule_type' => $filter__vehicule_types,
                'mark'          => $filter__marks,
                'model'         => $filter__models
          ));
        endif;


        ?>
        <h1 style="margin-top: 10px;font-size: 16px;background: #de0d0d;color: white;margin-right: 20px;line-height: 40px;padding: 2px 15px;border-radius: 4px 0 0 4px;text-align: end;display: flex;justify-content: space-between;">
            <span>Vehicle Management</span>
            <span>Mod-files TuningFiles Catalog</span>
        </h1>
        <link rel="stylesheet" type="text/css" href="<?php echo get_site_url().'/wp-content/plugins/'.$plugin_data['TextDomain'].'/assets/admin/style.css' ?>">
        <div id="fullManager" style="background: white;padding: 20px;border: 1px solid #ddd;margin-right: 20px;border-radius: 4px;">
            <input type="hidden" name="default_hostname" value="<?php echo get_site_url(); ?>">
            <input type="hidden" name="default_currency" value="<?php echo $this->currency_codes[$catalogData['currency_code']]['symbol'] ?>">
            <input type="hidden" name="default_vat" value="<?php echo $TVA ?>">
            <div class="row">
                <form class="VM__filter" name="VM__filter" >
                    <input type="hidden" name="page" value="__tuningfiles_vehicules-manager" >
                    <div class="form-group">
                        <select class="form-control _ajax_loaded" name="filter__vehicule_types"  >
                            <option value="" >Vehicle types</option>
                            <?php foreach ($vehicule_typeList['data'] as $key => $value): ?>
                            <option value="<?php echo $value['type']['id']; ?>" <?php echo ($value['type']['id']==$filter__vehicule_types) ? 'selected' : '' ?> ><?php echo $value['type']['name']['en'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <select class="form-control _ajax_loaded" name="filter__marks"  >
                            <option value="" >Marks</option>
                            <?php foreach ($marksList['data'] as $key => $value): ?>
                            <option value="<?php echo $value['mark']['id']; ?>" <?php echo ($value['mark']['id']==$filter__marks) ? 'selected' : '' ?> ><?php echo $value['mark']['name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <select class="form-control _ajax_loaded" name="filter__models"  >
                            <option value="" >Models</option>
                            <?php if (isset($filter__models)): ?>
                                <?php foreach ($modelsList['data'] as $key => $value): ?>
                                <option value="<?php echo $value['model']['id']; ?>" <?php echo ($value['model']['id']==$filter__models) ? 'selected' : '' ?> ><?php echo $value['model']['name'] ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <select class="form-control" name="filter__years"  >
                            <option value="" >Construction years</option>
                            <?php if (isset($filter__years)): ?>
                                <?php foreach ($yearsList['data'] as $key => $value):
                                    $year_textFormat = $value['production_year']['start'].'-'.$value['production_year']['end'];
                                    if ($value['production_year']['end']==0) {
                                        $year_textFormat = 'From '.$value['production_year']['start'];
                                    }
                                    
                                 ?>
                                <option value="<?php echo $value['production_year']['start'].'-'.$value['production_year']['end']; ?>" <?php echo ($value['production_year']['start'].'-'.$value['production_year']['end']==$filter__years) ? 'selected' : '' ?> ><?php echo  ((isset($value['model_type'])) ? $value['model_type']['name'].' | ' : '').$year_textFormat ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <input type="submit" class="button" name="search" value="Search" >
                    </div>
                </form>
            </div>
            <div class="col response"></div> 
            <div class="col">
               <table class="wp-list-table" border="0" cellpadding="0" cellspacing="0" >
                    <thead>
                        <tr>
                            <th class="manage-column" >Image</th>
                            <th class="manage-column" >Type</th>
                            <th class="manage-column" >Mark</th>
                            <th class="manage-column" >Model</th>
                            <th class="manage-column" >Engine</th>
                            <th class="manage-column" >Year</th>
                            <th class="manage-column" >BHP Origin</th>
                            <th class="manage-column" >BHP Modified</th>
                            <th class="manage-column" >Torque Origin</th>
                            <th class="manage-column" >Torque Modified</th>
                            <th class="manage-column" >Price HT</th>
                            <th class="manage-column" style="display:none;">Price TTC</th>
                            <th class="manage-column" ></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($vehiculesList['data'] as $vehicule_item): 

                        $editedCalalogItem = $wpdb->get_row("SELECT * 
                                                       FROM {$wpdb->prefix}tuningfiles_edited_vehicules 
                                                       WHERE api_vehicule_id=".$vehicule_item['id'] , ARRAY_A  );

                         
                        $edited_bhp    = $vehicule_item['hp']['system'];
                        $edited_torque = $vehicule_item['torque']['system'];
                        $price_ht      = '-';
                        $price_ttc     = '-';
                        $edited_bhp_status       = false;
                        $edited_torque_status    = false;
                        $edited_price_ht_status  = false;
                        $edited_price_ttc_status = false;

                        if (isset($editedCalalogItem) AND !empty($editedCalalogItem)):

                            if (isset($editedCalalogItem['bhp_system']) AND $editedCalalogItem['bhp_system']!=''):
                                $edited_bhp    = $editedCalalogItem['bhp_system']."hp";
                                $edited_bhp_status = true;
                            endif;
                            if (isset($editedCalalogItem['torque_system']) AND $editedCalalogItem['torque_system']!=''):
                                $edited_torque    = $editedCalalogItem['torque_system']."Nm";
                                $edited_torque_status = true;
                            endif;

                            if (isset($price_ht) AND $editedCalalogItem['price_ht'] > 0 ):
                                $price_ht    = $editedCalalogItem['price_ht'].' '.$this->currency_codes[$catalogData['currency_code']]['symbol'];
                                $price_ttc   = floatval(floatval($editedCalalogItem['price_ht']) * (1+($TVA/100))).' '.$this->currency_codes[$catalogData['currency_code']]['symbol'];
                                $edited_price_ht_status = true;
                                $edited_price_ttc_status = true;
                            


                            endif;
                        endif;

                        // Check unpublished vehicules : 
                        $unpublishedCalalogItem = $wpdb->get_row("SELECT * 
                                                       FROM {$wpdb->prefix}tuningfiles_unpublished_vehicules 
                                                       WHERE api_vehicule_id=".$vehicule_item['id'] , ARRAY_A  );


                        ?>
                     <tr data-id="<?php echo $vehicule_item['id']; ?>" >
                        <td><img src="<?php echo $vehicule_item['image'] ?>" width="70" ></td>
                        <td><?php echo $vehicule_item['type']['name']['en'] ?></td>
                        <td><?php echo $vehicule_item['mark']['name'] ?></td>
                        <td><?php echo $vehicule_item['model']['name'] ?></td>
                        <td><?php echo $vehicule_item['horsepower']['name'].' '.$vehicule_item['engine']['name'] ?></td>
                        <td><?php echo $vehicule_item['production_year']['start'].'-'.$vehicule_item['production_year']['end'] ?></td>
                        <td><?php echo $vehicule_item['hp']['standard'] ?></td>
                        <td class="<?php echo ($edited_bhp_status==true) ? 'client-edited' : '' ?>" >
                            <div class="edited-content" attr-id="bhp" default-original-value="<?php echo $vehicule_item['hp']['standard']; ?>" default-value="<?php echo $vehicule_item['hp']['system']; ?>" ><?php echo $edited_bhp; ?></div>
                            <span class="icon-table icon-editor edit__value" ></span>
                            <span class="icon-table icon-reset" title="Reset the default value"  ></span>
                        </td>
                        <td><?php echo $vehicule_item['torque']['standard'] ?></td>
                        <td class="<?php echo ($edited_torque_status==true) ? 'client-edited' : '' ?>" >
                            <div class="edited-content" attr-id="torque" default-original-value="<?php echo $vehicule_item['torque']['standard']; ?>" default-value="<?php echo $vehicule_item['torque']['system']; ?>" ><?php echo $edited_torque; ?></div>
                            <span class="icon-table icon-editor edit__value" ></span>
                            <span class="icon-table icon-reset" title="Reset the default value" ></span>
                        </td>
                        <td class="<?php echo ($edited_price_ht_status==true) ? 'client-edited' : '' ?>" >
                            <div class="edited-content" attr-id="price_ht"><?php echo $price_ht; ?></div>
                            <span class="icon-table icon-editor edit__value" ></span>
                            <span class="icon-table icon-reset" title="Reset the default value" ></span>
                        </td>
                        <td style="display:none;" class="<?php echo ($edited_price_ttc_status==true) ? 'client-edited' : '' ?>" >
                            <div class="edited-content" attr-id="price_ttc"><?php echo $price_ttc; ?></div>
                        </td>
                        <td>
                            <div class="button publish_vehicule_btn" data-id="<?php echo $vehicule_item['id']; ?>" ><?php 
                                if (isset($unpublishedCalalogItem) AND !empty($unpublishedCalalogItem)) echo 'Publish';
                                else echo 'Unpublish';
                             ?></div>
                        </td>
                     </tr>
                    <?php endforeach; ?>
                    </tbody>
               </table>
            </div>
        </div>
        <?php 
        $___link = array();
        if(isset($filter__vehicule_types) AND $filter__vehicule_types!='') $___link[] = 'filter__vehicule_types='.$filter__vehicule_types;
        if(isset($filter__marks) AND $filter__marks!='') $___link[] = 'filter__marks='.$filter__marks;
        if(isset($filter__models) AND $filter__models!='') $___link[] = 'filter__models='.$filter__models;
        if(isset($filter__years) AND $filter__years!='') $___link[] = 'filter__years='.$filter__years;
        $___link = implode('&', $___link);
        
        echo $catalogManager->listpagination($vehiculesList__all['total'] , 'admin.php?page=__tuningfiles_vehicules-manager&'.$___link , $cur_page , $par_page); ?>
        <?php
          /*<script type="text/javascript" src="<?php echo get_site_url().'/wp-content/plugins/'.$plugin_data['TextDomain'].'/assets/admin/script.js' ?>"  async></script>*/
    }
    /**
     * [edit_vehicule_value description]
     * @return [type] [description]
     */
    public function edit_vehicule_value() {
        
        global $wpdb; // this is how you get access to the database
        header('Content-Type: application/json');
        $response = array();
        
        $vehicule_id = (isset($_POST['vehicule_id']) AND $_POST['vehicule_id']!='') ? $_POST['vehicule_id'] : null ;  
        $value       = (isset($_POST['value']) AND $_POST['value']!='') ? $_POST['value'] : null ; 
        $attr        = (isset($_POST['attr']) AND $_POST['attr']!='') ? $_POST['attr'] : null ;  


        if (isset($value) AND $value > 0 ):
            $dictionary = array(
                'bhp'       => 'bhp_system',
                'torque'    => 'torque_system',
                'price_ht'  => 'price_ht',
                'price_ttc' => 'price_ttc',
            );

            $existEdiedVehicule = $wpdb->get_results( 
                        "SELECT * 
                         FROM {$wpdb->prefix}tuningfiles_edited_vehicules
                         WHERE  api_vehicule_id={$vehicule_id}" , 'ARRAY_A'); 
            
            // Edit the value of the exist row    
            if(isset($existEdiedVehicule) AND !empty($existEdiedVehicule)):
                $result = $wpdb->update(
                                "{$wpdb->prefix}tuningfiles_edited_vehicules",
                                array( $dictionary[$attr] => $value , 'updated_at' => time()),
                                array( 'api_vehicule_id' => $vehicule_id )
                            );
            // Add a new row 
            else:
                $result = $wpdb->insert(
                                "{$wpdb->prefix}tuningfiles_edited_vehicules",
                                array( 
                                    'api_vehicule_id' => $vehicule_id,
                                    $dictionary[$attr] => $value,
                                    'created_at' => time()

                                     )
                            );
            endif;

            if (isset($result) AND $result> 0 ):
                $response = array(
                    'status' => 'success',
                    'message' => 'Your value has been saved!'
                );
            else:
                $response = array(
                    'status' => 'error',
                    'message' => 'Something wrong, please try again later!'
                );
            endif;
        else:
            $response = array(
                'status' => 'success',
                'message' => 'Something wrong, please try again later!'
            );
        endif;



        echo json_encode($response);
        die();
    }
    /**
     * [callback__filterListManager description]
     * @return [type] [description]
     */
    public function filterListManager(){

        header('Content-Type: application/json');

        $sub_action    = (isset($_POST['sub_action']) AND $_POST['sub_action']!='') ? $_POST['sub_action'] : null;
        $vehicule_type = (isset($_POST['vehicule_type']) AND $_POST['vehicule_type']!='') ? $_POST['vehicule_type'] : null;
        $mark          = (isset($_POST['mark']) AND $_POST['mark']!='') ? $_POST['mark'] : null;
        $model         = (isset($_POST['model']) AND $_POST['model']!='') ? $_POST['model'] : null;
        $engine        = (isset($_POST['engine']) AND $_POST['engine']!='') ? $_POST['engine'] : null;
        $horsepower    = (isset($_POST['horsepower']) AND $_POST['horsepower']!='') ? $_POST['horsepower'] : null;

        

        if ($sub_action):

            $catalogDispatcher = new UBY_catalog_dispatcher(array() , array());
            
            $response = array();
            switch ($sub_action):
                case 'getMarks':
                    //Get mark list : 
                    $response = $catalogDispatcher->sbs_getMarks(array(
                                    'vehicule_type' => $vehicule_type
                                    ));
                    
                    $response = $response['data']; 
                break;
                case 'getModels':
                    // Get model list 
                    $response = $catalogDispatcher->sbs_getModels(array(
                                    'vehicule_type' => $vehicule_type,
                                    'mark'          => $mark
                                    ));
                    
                    $response = $response['data']; 
                break;
                case 'getYears':
                     $response = $catalogDispatcher->sbs_getProductionYear(array(
                                'vehicule_type' => $vehicule_type,
                                'mark'          => $mark,
                                'model'         => $model
                                ));
                    $response = $response['data']; 
                break;
                    
            endswitch;    
        endif;

        if(isset($response) AND !empty($response)):
            $response = array(
                'status' => 'success',
                'data' => $response
            );
        else:
             $response = array(
                'status' => 'error',
                'message' => 'Error'
            );
        endif;
        echo json_encode($response);
        die();        
    }
    /**
     * [reset_vehicule_value description]
     * @return [type] [description]
     */
    public function reset_vehicule_value(){
        
        global $wpdb; // this is how you get access to the database
        header('Content-Type: application/json');
        $response = array();
        
        $vehicule_id = (isset($_POST['vehicule_id']) AND $_POST['vehicule_id']!='') ? $_POST['vehicule_id'] : null ;  
        $value       = (isset($_POST['value']) AND $_POST['value']!='') ? $_POST['value'] : null ; 
        $attr        = (isset($_POST['attr']) AND $_POST['attr']!='') ? $_POST['attr'] : null ;  


     
            $dictionary = array(
                'bhp'       => 'bhp_system',
                'torque'    => 'torque_system',
                'price_ht'  => 'price_ht',
                'price_ttc' => 'price_ttc',
            );


            // Edit the value of the exist row    
            $result = $wpdb->update(
                            "{$wpdb->prefix}tuningfiles_edited_vehicules",
                            array( $dictionary[$attr] => NULL , 
                                   'updated_at' => time()),
                            array( 'api_vehicule_id' => $vehicule_id )
                        );
        
            $allisNull = $wpdb->get_results( 
                        "SELECT * 
                         FROM {$wpdb->prefix}tuningfiles_edited_vehicules
                         WHERE api_vehicule_id={$vehicule_id}
                         AND bhp_system is NUll 
                         AND torque_system is NULL 
                         AND price_ht is NULL 
                         AND price_ttc is NULL " , 'ARRAY_A'); 

            if (isset($allisNull) AND  !empty($allisNull) ):
                // delete row 
                $wpdb->delete(
                    "{$wpdb->prefix}tuningfiles_edited_vehicules",
                    array(
                        'api_vehicule_id' => $vehicule_id
                    )
                );

            endif;


            if (isset($result) AND $result> 0 ):
                $response = array(
                    'status' => 'success',
                    'message' => 'Your value has been reset!'
                );
            else:
                $response = array(
                    'status' => 'error',
                    'message' => 'Something wrong, please try again later!'
                );
            endif;
        



        echo json_encode($response);
        die();
    }
    /**
     * [publish_vehicule description]
     * @return [type] [description]
     */
    public function publish_vehicule(){
        
        global $wpdb; // this is how you get access to the database
        header('Content-Type: application/json');
        
        $vehicule_id = (isset($_POST['id']) AND $_POST['id']!='') ? $_POST['id'] : null;
        $existUnpublishedVehicule = $wpdb->get_results( 
                        "SELECT * 
                         FROM {$wpdb->prefix}tuningfiles_unpublished_vehicules
                         WHERE  api_vehicule_id={$vehicule_id}" , 'ARRAY_A');

        $target_action = '';
        // unpublish ==>> publish
        if(isset($existUnpublishedVehicule) AND !empty($existUnpublishedVehicule)):

            $result = $wpdb->delete(
                            "{$wpdb->prefix}tuningfiles_unpublished_vehicules",
                            array( 'api_vehicule_id' => $vehicule_id )
                        );
            $target_action = 'unpublished';
        // Add a new row 
        else:
            $result = $wpdb->insert(
                            "{$wpdb->prefix}tuningfiles_unpublished_vehicules",
                            array( 
                                'api_vehicule_id' => $vehicule_id,
                                'created_at' => time()
                            )
                        );
            $target_action = 'published';
        endif;

        if (isset($result) AND $result> 0 ):
            $response = array(
                'status'        => 'success',
                'message'       => "The selected vehicle has been {$target_action} successfully.",
                'target_action' => $target_action
            );
        else:
            $response = array(
                'status' => 'error',
                'message' => 'Something wrong, please try again later!'
            );
        endif;

        echo json_encode($response);
        die();
    }
    /////////////////////////////
    // VEHICULES TARIFS RULES  //
    /////////////////////////////
    public function set_content_pricing_rules(){
        
        global $wpdb;

        $catalogData = null;
        $catalogData = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}tuningfiles_catalog WHERE id=1" , ARRAY_A  );

        $TVA = $catalogData['tva_payment'];
        $plugin_data = get_plugin_data( __FILE__ );
        // 
        $pricing_rules_items = $wpdb->get_results("SELECT * 
                                           FROM {$wpdb->prefix}tuningfiles_pricing_rules ORDER BY order_no ASC
                                           " , ARRAY_A  );



                         
        ?>
        <h1 style="margin-top: 10px;font-size: 16px;background: #de0d0d;color: white;margin-right: 20px;line-height: 40px;padding: 2px 15px;border-radius: 4px 0 0 4px;text-align: end;display: flex;justify-content: space-between;">
            <span>Pricing Rules</span>
            <span>Mod-files TuningFiles Catalog</span>
        </h1>
        <div class="notice notice-warning" style="margin: 10px 0;padding: 10px;">Please note that customized vehicle prices take precedence over pricing rules</div>
        <link rel="stylesheet" type="text/css" href="<?php echo get_site_url().'/wp-content/plugins/'.$plugin_data['TextDomain'].'/assets/admin/style.css' ?>">
        <div id="fullManager" style="background: white;padding: 20px;border: 1px solid #ddd;margin-right: 20px;border-radius: 4px;">
            <input type="hidden" name="default_hostname" value="<?php echo get_site_url(); ?>">
            <input type="hidden" name="default_currency" value="<?php echo $this->currency_codes[$catalogData['currency_code']]['symbol'] ?>">
            <input type="hidden" name="default_vat" value="<?php echo $TVA ?>">
            <div class="menu-actions">
                <ul>
                    <li><a href="admin.php?page=__tuningfiles_pricing-rules_form" class="button" >Add new rule</a></li>
                </ul>
            </div>
            <div class="col response"></div> 
            <div class="col">
               <table id="pricing_rules_content" class="wp-list-table" border="0" cellpadding="0" cellspacing="0" >
                    <thead>
                        <tr>
                            <th class="manage-column" ></th>
                            <th class="manage-column" >Type</th>
                            <th class="manage-column" >Mark</th>
                            <th class="manage-column" >Model</th>
                            <th class="manage-column" >Min Year</th>
                            <th class="manage-column" >Max Year</th>
                            <th class="manage-column" >Min BHP Origin</th>
                            <th class="manage-column" >Max BHP Origin</th>
                            <th class="manage-column" >Min Torque Origin</th>
                            <th class="manage-column" >Max Torque Origin</th>
                            <th class="manage-column" >Price HT</th>
                            <th class="manage-column" style="display: none;" >Price TTC</th>
                            <th class="manage-column" >Statut</th>
                            <th class="manage-column" >Date</th>
                            <th class="manage-column" ></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php if (isset($pricing_rules_items) AND !empty($pricing_rules_items)):   ?>
                        <?php foreach ($pricing_rules_items as $rule_item):   ?>
                        <tr data-id="<?php echo $rule_item['id']; ?>" position="<?php echo $rule_item['order_no']; ?>" >
                            <td><span class="scroll-icon"></span></td>
                            <td><?php echo $rule_item['vehicule_type'] ?></td>
                            <td><?php echo $rule_item['mark'] ?></td>
                            <td><?php echo $rule_item['model'] ?></td>
                            <td><?php echo $rule_item['min_year'] ?></td>
                            <td><?php echo $rule_item['max_year'] ?></td>
                            <td><?php echo $rule_item['min_original_puissance'] ?></td>
                            <td><?php echo $rule_item['max_original_puissance'] ?></td>
                            <td><?php echo $rule_item['min_original_torque'] ?></td>
                            <td><?php echo $rule_item['max_original_torque'] ?></td>
                            <td><?php echo $rule_item['price_ht'].' '.$this->currency_codes[$catalogData['currency_code']]['symbol']; ?></td>
                            <td style="display: none;"><?php echo $rule_item['price_ttc'].' '.$this->currency_codes[$catalogData['currency_code']]['symbol']; ?></td>
                            <td class='status'><?php 
                                switch($rule_item['status']):
                                    case "activated": echo '<font style="color:green;" >Activated</font>'; break;
                                    case "unactivated": echo '<font style="color:red" >Unactivated</font>'; break;
                                endswitch;

                             ?></td>
                             <td><?php echo date('d/m/Y H:i' , $rule_item['created_at']); ?></td>
                            <td style="width: 170px;">
                                <a href="admin.php?page=__tuningfiles_pricing-rules_form&id=<?php echo $rule_item['id'] ?>" class="button _icon_btn _icon_edit" title="Edit" ><span></span></a>
                                <div class="button delete_pricing_rule_btn _icon_btn _icon_delete" data-id="<?php echo $rule_item['id']; ?>" title="Delete"><span></span></div> 
                                <div class="button enable_pricing_rule_btn" data-id="<?php echo $rule_item['id']; ?>" ><?php 
                                    if ($rule_item['status']!='activated') echo 'Enable Rule';
                                    else echo 'Disable Rule';
                                 ?></div>
                            </td>
                         </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="14"><div class="notice notice-warning">No results found</div></td>
                    </tr> 
                    <?php endif; ?>
                    </tbody>
               </table>
            </div>
        </div>
        <?php
    }

    public function set_content_form_add_new_pricing_rule(){
        global $wpdb;


        $catalogData = null;
        $catalogData = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}tuningfiles_catalog WHERE id=1" , ARRAY_A  );

        $TVA = $catalogData['tva_payment'];
        $plugin_data = get_plugin_data( __FILE__ );

        $mode = 'new';
        /** EDIT MODE  */
        if(isset($_GET['id']) AND $_GET['id']!=''):
            $pricingRuleData = $wpdb->get_row("
                                SELECT * 
                                FROM {$wpdb->prefix}tuningfiles_pricing_rules 
                                WHERE id={$_GET['id']}" , ARRAY_A  );

            if (isset($pricingRuleData) AND !empty($pricingRuleData)):
                $mode = 'edit';


            endif;

        endif;


        $catalogDispatcher = new UBY_catalog_dispatcher(array() , array());
        // Get vehicule type list : 
        $vehicule_typeList = $catalogDispatcher->tfc_getVechileTypes();
        // Get mark list : 
        if ($mode=='edit' AND isset($pricingRuleData['vehicule_type_permalink'])):
            $marksList = $catalogDispatcher->sbs_getMarks(array(
                'vehicule_type' => $pricingRuleData['vehicule_type_permalink']
            ));
        endif;
        // // Get model list 
        if (isset($pricingRuleData['vehicule_type_permalink']) AND isset($pricingRuleData['mark_permalink'])):
            $modelsList = $catalogDispatcher->sbs_getModels(array(
                'vehicule_type' => $pricingRuleData['vehicule_type_permalink'],
                'mark'          => $pricingRuleData['mark_permalink']
          ));
        endif;
     
        ?>
        <h1 style="margin-top: 10px;font-size: 16px;background: #de0d0d;color: white;margin-right: 20px;line-height: 40px;padding: 2px 15px;border-radius: 4px 0 0 4px;text-align: end;display: flex;justify-content: space-between;">
            <span><?php 
                if($mode=='edit'):
                    echo 'Edit Pricing Rule';
                else:
                    echo 'Add New Pricing Rule';
                endif;
             ?></span>
             <span>Mod-files TuningFiles Catalog</span>
        </h1>
        <link rel="stylesheet" type="text/css" href="<?php echo get_site_url().'/wp-content/plugins/'.$plugin_data['TextDomain'].'/assets/admin/style.css' ?>">
        <div id="fullManager" style="background: white;padding: 20px;border: 1px solid #ddd;margin-right: 20px;border-radius: 4px;">
            <form class="pricing_rule_form" name="pricing_rule_form"  >
                <?php if ($mode=='edit'): ?>
                <input type="hidden" name="id" value="<?php echo $_GET['id'] ?>" >
                <?php endif; ?>
                <div class="form-group">
                    <label>Vehicle type</label>
                    <select class="form-control _ajax_loaded" name="int__vehicule_types"  >
                        <option value="" >Choose</option>
                        <?php if (isset($vehicule_typeList['data']) AND count($vehicule_typeList['data'])): ?>
                            <?php foreach ($vehicule_typeList['data'] as $key => $value): ?>
                            <option value="<?php echo $value['type']['id']; ?>" <?php echo ($value['type']['id']==$pricingRuleData['vehicule_type_permalink']) ? 'selected' : '' ?> ><?php echo $value['type']['name']['en'] ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Mark</label>
                    <select class="form-control _ajax_loaded" name="int__marks"  >
                        <option value="" >Choose</option>
                        <?php 
                        if ($mode=='edit'):
                            if(isset($marksList['data']) AND count($marksList['data'])):
                                foreach ($marksList['data'] as $key => $value): ?>
                                <option value="<?php echo $value['mark']['id']; ?>" <?php echo ($value['mark']['id']==$pricingRuleData['mark_permalink']) ? 'selected' : '' ?> ><?php echo $value['mark']['name'] ?></option>
                                <?php 
                                endforeach;
                            endif;
                        endif; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Model</label>
                    <select class="form-control " name="int__models"  >
                        <option value="" >Choose</option>
                       
                            <?php 
                            if ($mode=='edit'):
                                if (isset($modelsList['data']) AND count($modelsList['data'])): 
                                    foreach ($modelsList['data'] as $key => $value): ?>
                                    <option value="<?php echo $value['model']['id']; ?>" <?php echo ($value['model']['id']==$pricingRuleData['model_permalink']) ? 'selected' : '' ?> ><?php echo $value['model']['name'] ?></option>
                                    <?php endforeach;
                                endif;
                            endif; ?>
                       
                    </select>
                </div>
                <div class="form-group">
                    <label>Year</label>
                    <select class="form-control " name="int__min_year"  >
                        <option value="" >Choose</option>
                    <?php for ($i=date('Y', time()); $i >= 1900 ; $i--): ?>
                        <option value="<?php echo $i ?>" <?php echo ($mode=='edit' AND $i==$pricingRuleData['min_year']) ? 'selected' : '' ?> ><?php echo $i ?></option>
                    <?php endfor;?>
                    </select>
                    <select class="form-control " name="int__max_year"  >
                        <option value="" >Choose</option>
                    <?php for ($i=date('Y', time()); $i >= 1900 ; $i--): ?>
                        <option value="<?php echo $i ?>" <?php echo ($mode=='edit' AND $i==$pricingRuleData['max_year']) ? 'selected' : '' ?> ><?php echo $i ?></option>
                    <?php endfor;?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Original Bhp</label>
                    <input type="text" placeholder="Min hp" name="int__min_hp" value='<?php echo ($mode=='edit' AND $pricingRuleData['min_original_puissance']) ? $pricingRuleData['min_original_puissance'] : '' ?>' class="form-control"><span>HP</span>
                    <input type="text" placeholder="Max hp" name="int__max_hp" value='<?php echo ($mode=='edit' AND $pricingRuleData['max_original_puissance']) ? $pricingRuleData['max_original_puissance'] : '' ?>' class="form-control"><span>HP</span>
                </div>
                <div class="form-group">
                    <label>Original Torque</label>
                    <input type="text" placeholder="Min Torque" name="int__min_torque" value='<?php echo ($mode=='edit' AND $pricingRuleData['min_original_torque']) ? $pricingRuleData['min_original_torque'] : '' ?>' class="form-control"><span>NM</span>
                    <input type="text" placeholder="Max Torque" name="int__max_torque" value='<?php echo ($mode=='edit' AND $pricingRuleData['max_original_torque']) ? $pricingRuleData['max_original_torque'] : '' ?>' class="form-control"><span>NM</span>
                </div>
                <div class="form-group">
                    <label>Price HT</label>
                    <input type="text" class="form-control" name="int__price_ht" value='<?php echo ($mode=='edit' AND $pricingRuleData['price_ht']) ? $pricingRuleData['price_ht'] : '' ?>'><span><?php echo $this->currency_codes[$catalogData['currency_code']]['symbol'] ?></span>
                </div>
                <div class="form-group" style="display: none;">
                    <label>Price TTC</label>
                    <input type="text" class="form-control" disabled="" value='<?php echo ($mode=='edit' AND $pricingRuleData['price_ttc']) ? $pricingRuleData['price_ttc'] : '' ?>'><span><?php echo $this->currency_codes[$catalogData['currency_code']]['symbol'] ?></span>
                </div>
                <div class="form-group">
                    <input type="submit" class="button" value="Save!"   >
                    <div class="response"></div>
                </div>
            </form>
        </div>
        <?php

    }
    /**
     * [set_pricing_rule description]
     */
    public function set_pricing_rule(){

        global $wpdb;

        $response = array();

        $rule_id                 = (isset($_POST['rule_id']) AND $_POST['rule_id']!='') ? $_POST['rule_id'] : null;            
        $vehicule_type           = (isset($_POST['vehicule_type']) AND $_POST['vehicule_type']!='' AND $_POST['vehicule_type']!='Choose') ? $_POST['vehicule_type'] : null;            
        $vehicule_type_permalink = (isset($_POST['vehicule_type_handle']) AND $_POST['vehicule_type_handle']!='') ? $_POST['vehicule_type_handle'] : null;            
        $mark                    = (isset($_POST['mark']) AND $_POST['mark']!='' AND $_POST['mark']!='Choose') ? $_POST['mark'] : null;            
        $mark_permalink          = (isset($_POST['mark_handle']) AND $_POST['mark_handle']!='') ? $_POST['mark_handle'] : null;            
        $model                   = (isset($_POST['model']) AND $_POST['model']!='' AND $_POST['model']!='Choose') ? $_POST['model'] : null;            
        $model_permalink         = (isset($_POST['model_handle']) AND $_POST['model_handle']!='') ? $_POST['model_handle'] : null;            
        $min_year                = (isset($_POST['min_year']) AND $_POST['min_year']!='') ? $_POST['min_year'] : null;            
        $max_year                = (isset($_POST['max_year']) AND $_POST['max_year']!='') ? $_POST['max_year'] : null;            
        $min_hp                  = (isset($_POST['min_hp']) AND $_POST['min_hp']!='') ? $_POST['min_hp'] : null;            
        $max_hp                  = (isset($_POST['max_hp']) AND $_POST['max_hp']!='') ? $_POST['max_hp'] : null;            
        $min_torque              = (isset($_POST['min_torque']) AND $_POST['min_torque']!='') ? $_POST['min_torque'] : null;            
        $max_torque              = (isset($_POST['max_torque']) AND $_POST['max_torque']!='') ? $_POST['max_torque'] : null;            
        $price_ht                = (isset($_POST['price_ht']) AND $_POST['price_ht']!='') ? $_POST['price_ht'] : null;            
        
        // General config
        $catalogData = null;
        $catalogData = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}tuningfiles_catalog WHERE id=1" , ARRAY_A  );

        $TVA = $catalogData['tva_payment'];
        $price_ttc   = floatval(floatval($price_ht) * (1+($TVA/100)));//.' '.$this->currency_codes[$catalogData['currency_code']]['symbol'];


        // Condition : Verification year interval
        if (isset($min_year) AND $min_year > 0 AND isset($max_year) AND $max_year > 0 AND $min_year > $max_year ):
            $response = array(
                'status' => 'error',
                'message' => 'Please check the years interval'
            );
            echo json_encode($response);
            die();
        endif;

        if (isset($min_hp) AND $min_hp > 0 AND isset($max_hp) AND $max_hp > 0 AND $min_hp > $max_hp ):
            $response = array(
                'status' => 'error',
                'message' => 'Please check the Hp interval'
            );
            echo json_encode($response);
            die();
        endif;

        if (isset($min_torque) AND $min_torque > 0 AND isset($max_torque) AND $max_torque > 0 AND $min_torque > $max_torque ):
            $response = array(
                'status' => 'error',
                'message' => 'Please check the torque interval'
            );
            echo json_encode($response);
            die();
        endif;
        // save !
        if (isset($price_ht) AND $price_ht >= 0 ):

            if (isset($rule_id) AND $rule_id!=''):
                $pricingRuleData = $wpdb->get_row("
                                    SELECT * 
                                    FROM {$wpdb->prefix}tuningfiles_pricing_rules 
                                    WHERE id={$rule_id}" , ARRAY_A  );

                if (isset($pricingRuleData) AND !empty($pricingRuleData)):
                    $mode = 'edit';
                endif;
            endif;

            

            $db_args = array(
                'vehicule_type'           => $vehicule_type,
                'vehicule_type_permalink' => $vehicule_type_permalink,
                'mark'                    => $mark,
                'mark_permalink'          => $mark_permalink,
                'model'                   => $model,
                'model_permalink'         => $model_permalink,
                'min_year'                => $min_year,
                'max_year'                => $max_year,
                'min_original_puissance'  => $min_hp,
                'max_original_puissance'  => $max_hp,
                'min_original_torque'     => $min_torque,
                'max_original_torque'     => $max_torque,
                'price_ht'                => $price_ht,
                'price_ttc'               => $price_ttc,
                'status'                  => 'activated',
                'created_at'              => time(),
            );

            if ($mode=='edit'):
                 $result = $wpdb->update(
                            "{$wpdb->prefix}tuningfiles_pricing_rules",
                            $db_args,
                            array( 'id' => $rule_id)
                        );
            else:
                $result = $wpdb->insert(
                            "{$wpdb->prefix}tuningfiles_pricing_rules",
                            $db_args
                        );
            endif;



            if (isset($result)):
                $response = array(
                    'status'  => 'success',
                    'message' => 'Your pricing rule has been successfully saved.'
                );
                echo json_encode($response);
                die();
            else:
                $response = array(
                    'status'  => 'error',
                    'message' => 'Something wrong, please try again later!'
                );
                echo json_encode($response);
                die();
            endif;

        else:
            $response = array(
                'status' => 'error',
                'message' => 'The price field is missing, please enter a value for this rule'
            );
            echo json_encode($response);
            die();
        endif;
        echo '<pre>';
        print_r($_POST);
    }

    public function enable_pricing_rule(){
        
        global $wpdb; // this is how you get access to the database
        header('Content-Type: application/json');
        
        $rule_id = (isset($_POST['id']) AND $_POST['id']!='') ? $_POST['id'] : null;
        $pricingRuleData = $wpdb->get_row( 
                        "SELECT * 
                         FROM {$wpdb->prefix}tuningfiles_pricing_rules
                         WHERE  id={$rule_id}" , 'ARRAY_A');

        $target_action = '';
        // unpublish ==>> publish
        if(isset($pricingRuleData) AND !empty($pricingRuleData)):

            if ($pricingRuleData['status']=='activated'):
                $target_action = 'unactivated';
            else:
                $target_action = 'activated';
            endif;
            

            $result = $wpdb->update(
                        "{$wpdb->prefix}tuningfiles_pricing_rules",
                        array( 'status' => $target_action ),
                        array( 'id' => $rule_id)
                    );
        
            if (isset($result) AND $result> 0 ):
                $response = array(
                    'status'        => 'success',
                    'message'       => "The selected rule has been {$target_action} successfully.",
                    'target_action' => $target_action
                );
            else:
                $response = array(
                    'status' => 'error',
                    'message' => 'Something wrong, please try again later!'
                );
            endif;
         
        else:
            $response = array(
                'status' => 'error',
                'message' => 'Something wrong, please try again later!'
            );
             
        endif;


        echo json_encode($response);
        die();
    }

    public function change_priority_pricing_rule(){

        global $wpdb;

        $RULE_LIST = (isset($_POST['pricing_rules_list']) AND $_POST['pricing_rules_list']!='') ? $_POST['pricing_rules_list'] : null;
        // update offers :
        $succeed_operation=0;
        foreach ($RULE_LIST as $key => $value):

           
           $response_save = $wpdb->update(
                "{$wpdb->prefix}tuningfiles_pricing_rules",
                array( 'order_no' => $value['position'] ),
                array( 'id' => $value['data-id'] ),
                array('%d'),
                array('%d')
                );
               
            if ($response_save!=false OR $response_save >=0):
                $succeed_operation++;
            endif;
             
        endforeach;

        if ($succeed_operation!=count($RULE_LIST)):
            $response = array(
                'status' => 'error',
                'message' => "An error occurred when changing the priorities of rules, please try again later."
            );
        else:
            $response = array(
                'status' => 'success',
                'message' => "Rule priority was successfully changed"
            );
        endif;

        echo @json_encode($response);
        die();

    }

    public function delete_pricing_rule(){

        global $wpdb; // this is how you get access to the database
        header('Content-Type: application/json');
        
        $rule_id = (isset($_POST['id']) AND $_POST['id']!='') ? $_POST['id'] : null;
        $pricingRuleData = $wpdb->get_row( 
                        "SELECT * 
                         FROM {$wpdb->prefix}tuningfiles_pricing_rules
                         WHERE  id={$rule_id}" , 'ARRAY_A');

        
        // unpublish ==>> publish
        if(isset($pricingRuleData) AND !empty($pricingRuleData)):

            
            

            $result = $wpdb->delete(
                        "{$wpdb->prefix}tuningfiles_pricing_rules",
                        array( 'id' => $rule_id )
                        
                    );
        
            if (isset($result) AND $result> 0 ):
                $response = array(
                    'status'        => 'success',
                    'message'       => "The selected rule has been deleted successfully.",
                    
                );
            else:
                $response = array(
                    'status' => 'error',
                    'message' => 'Something wrong, please try again later!'
                );
            endif;
         
        else:
            $response = array(
                'status' => 'error',
                'message' => 'Something wrong, please try again later!'
            );
             
        endif;


        echo json_encode($response);
        die();
    }
    

    /**
     * [install description]
     * @return [type] [description]
     */
    public static function install()
    {
        global $wpdb;

        /** CREATION TABLE TUNINGFILES_CATALOG */
        $wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->prefix}tuningfiles_catalog 
                    (
                    id int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
                    company_name varchar(255) DEFAULT NULL,
                    catalog_name varchar(255) DEFAULT NULL,
                    api_key varchar(255) DEFAULT NULL,
                    api_secret varchar(255) DEFAULT NULL,
                    display_lang varchar(255) DEFAULT NULL,
                    display_width varchar(255) DEFAULT NULL,
                    style_background_color varchar(255) DEFAULT NULL,
                    style_font_color varchar(255) DEFAULT NULL,
                    style_margin_top varchar(255) DEFAULT NULL,
                    style_template_display_photo int(11) DEFAULT NULL,
                    style_template_display_long_description int(11) DEFAULT NULL,
                    style_template_display_sub_items int(11) DEFAULT NULL,
                    style_template_display_chart int(11) DEFAULT NULL,
                    style_template_display_breadcrumb int(11) DEFAULT NULL,
                    currency_code varchar(20) NOT NULL DEFAULT 'EUR',
                    tva_payment int(11) NOT NULL DEFAULT '0',
                    show_vehicles_prices int(11) DEFAULT '1',
                    displayed_vehicules_types varchar(255) DEFAULT '[\"agricultures\",\"bus\",\"cars\",\"construction-machines\",\"jetski\",\"motos\",\"quads\",\"trucks\"]',
                    _time_creation varchar(255) DEFAULT NULL
                    );");
        /** Insert default line */
        $wpdb->query("INSERT INTO {$wpdb->prefix}tuningfiles_catalog 
            (company_name , catalog_name , api_key , api_secret , display_lang , display_width , style_background_color , style_font_color ,  style_margin_top, style_template_display_photo, style_template_display_long_description, style_template_display_sub_items, style_template_display_chart,style_template_display_breadcrumb,_time_creation,displayed_vehicules_types) 
            VALUES ('' ,'Reprogrammation', '' , '' , 'en' ,'boxed_width_theme' , '#FFFFFF' , '#333333' , '10','1','1','1','1','1', '".time()."','[\"agricultures\",\"bus\",\"cars\",\"construction-machines\",\"jetski\",\"motos\",\"quads\",\"trucks\"]' ) ");

        
        /** CREATION TABLE TUNINGFILES_EDITED_VEHICLES */
        $wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->prefix}tuningfiles_edited_vehicules 
            (
            id int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
            api_vehicule_id int(11) DEFAULT NULL,
            bhp_system double DEFAULT NULL,
            torque_system double DEFAULT NULL,
            price_ht double DEFAULT NULL,
            price_ttc double DEFAULT NULL,
            created_at varchar(255) DEFAULT NULL,
            updated_at varchar(255) DEFAULT NULL 
            );
    
            ");

        $wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->prefix}tuningfiles_pricing_rules 
            (
            id int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
            vehicule_type varchar(255) DEFAULT NULL,
            vehicule_type_permalink varchar(255) DEFAULT NULL,
            mark varchar(255) DEFAULT NULL,
            mark_permalink varchar(255) DEFAULT NULL,
            model varchar(255) DEFAULT NULL,
            model_permalink varchar(255) DEFAULT NULL,
            min_year int(11) DEFAULT NULL,
            max_year int(11) DEFAULT NULL,
            min_original_puissance int(11) DEFAULT NULL,
            max_original_puissance int(11) DEFAULT NULL,
            min_original_torque int(11) DEFAULT NULL,
            max_original_torque int(11) DEFAULT NULL,
            price_ht double DEFAULT NULL,
            price_ttc double DEFAULT NULL,
            order_no int(11) DEFAULT '1',
            status varchar(20) DEFAULT 'activated',
            created_at varchar(255) DEFAULT NULL
            );
    
            ");        
        $wpdb->query("CREATE TABLE IF NOT EXISTS {$wpdb->prefix}tuningfiles_unpublished_vehicules 
            (
            id int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
            api_vehicule_id int(11) DEFAULT NULL,
            created_at varchar(255) DEFAULT NULL
            );
    
            "); 

        set_transient( 'vpt_flush', 1, 20 );
    }   

    /**
     * [uninstall description]
     * @return [type] [description]
     */
    public static function uninstall()
    {
        global $wpdb;

        $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}tuningfiles_catalog;");
        $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}tuningfiles_edited_vehicules;");
        $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}tuningfiles_pricing_rules;");
        $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}tuningfiles_unpublished_vehicules;");
    }

} 
?>