<?php

/**
* UBY_catalog_dispatcher
*
* @uses     
*
* @category Category
* @package  Package
* @author   UbyMedia
* @license  
* @link     
*/
class UBY_catalog_manager 
{
	private $CHIP_API_KEY        = '';
    private $CHIP_API_SECRET     = '';
    public  $catalogConfig       = null;



    public function __construct(){
    	global $wpdb;

    	$this->catalogConfig = $wpdb->get_results( 
					"SELECT * FROM {$wpdb->prefix}tuningfiles_catalog
					 WHERE  id=1" , 'ARRAY_A');	
        $this->catalogConfig = $this->catalogConfig[0];

    	/**
         * CONFIG API */
        $this->CHIP_API_KEY    = $this->catalogConfig['api_key'];
        $this->CHIP_API_SECRET = $this->catalogConfig['api_secret'];





    }


    /**
     * [get description]
     * @param  array  $data [description]
     * @return [type]       [description]
     */
	public function get($data = array(

		'vehicule_type'    => 'cars' ,
		'mark'             => false ,
		'model'            => false ,
		'year'             => false ,
		'pagination_index' => 1 ,
		'pagination_page'  => 10 ,
		
		)){

		$additional_query = "";
		if(isset($data['mark']) AND $data['mark']!='') $additional_query .="marks/{$data['mark']}/";
		if(isset($data['model']) AND $data['model']!='') $additional_query .="models/{$data['model']}/";
		if(isset($data['year']) AND $data['year']!='') {
			$yearParts = explode('-', $data['year']);
			$additional_query .="yfrom/{$yearParts[0]}/yto/{$yearParts[1]}/";
		}

		$url = 'https://www.mod-files.com/api/chip/v1/types/'.$data['vehicule_type'].'/'.$additional_query.'?' . http_build_query([
			'api_key'    => $this->CHIP_API_KEY,
			'api_secret' => $this->CHIP_API_SECRET,
			'fields'     => ($data['pagination_page']!='') ? 'id,mark,model,engine,model_type,horsepower,hp,torque,production_start_year,production_end_year,image' : '',
			'sort'       => 'id',
			'range'      => ($data['pagination_page']!='') ? $data['pagination_index'].'-'.$data['pagination_page'] : '' ,
			'nodata'     => ($data['pagination_page']!='') ? '' : '1'
        ]);

        // echo $url;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POST, 0);
        $response = curl_exec($ch);

         
        error_log($response);
        return json_decode($response , true);



	}

	public function listpagination($count , $lienCourrant , $cur_page , $par_page ){
         $previous_btn = true;
         $next_btn     = true;
         $first_btn    = true;
         $last_btn     = true;

         $no_of_paginations = ceil($count / $par_page);
         

         $et="&";
         if ($lienCourrant=="" OR substr($lienCourrant, -1)=='/') $et="?";

         if ($cur_page >= 7) {
            $start_loop = $cur_page - 3;
            if ($no_of_paginations > $cur_page + 3)
                $end_loop = $cur_page + 3;
            else if ($cur_page <= $no_of_paginations && $cur_page > $no_of_paginations - 6) {
                $start_loop = $no_of_paginations - 6;
                $end_loop = $no_of_paginations;
            } else {
                $end_loop = $no_of_paginations;
            }
         } else {
            $start_loop = 1;
            if ($no_of_paginations > 7)
                $end_loop = 7;
            else
                $end_loop = $no_of_paginations;
         }


         $msg = "<div class='wrappagi text-center' ><ul class='pagination'>";

                // pour activer le premier bouton
                if ($first_btn && $cur_page > 1) {
                    $msg .= "<li p='1' ><a href='".$lienCourrant.$et."p=1' >First</a></li>";
                } else if ($first_btn) {
                    $msg .= "<li p='1' ><a href='#' >First</a></li>";
                }

                // pour activer le bouton precedent
                if ($previous_btn && $cur_page > 1) {
                    $pre = $cur_page - 1;
                    $msg .= "<li p='$pre' ><a href='".$lienCourrant.$et."p=$pre' >Previous</a></li>";
                } else if ($previous_btn) {
                    $msg .= "<li ><a href='#' >Previous</a></li>";
                }
                for ($i = $start_loop; $i <= $end_loop; $i++) {

                    if ($cur_page == $i)
                        $msg .= "<li p='$i'  class='active'><a href='".$lienCourrant.$et."p=$i' >{$i}</a></li>";
                    else
                        $msg .= "<li p='$i' ><a href='".$lienCourrant.$et."p=$i' >{$i}</a></li>";
                }




                // pour activer le bouton suivant
                if ($next_btn && $cur_page < $no_of_paginations) {
                    $nex = $cur_page + 1;
                    $msg .= "<li p='$lienCourrant&p=$nex' ><a href='".$lienCourrant.$et."p=$nex' >Next</a></li>";
                } else if ($next_btn) {
                    $msg .= "<li ><a href='#' >Next</a></li>";
                }

                // pour activer le dernier bouton
                if ($last_btn && $cur_page < $no_of_paginations) {
                    $msg .= "<li p='$no_of_paginations' ><a href='".$lienCourrant.$et."p=$no_of_paginations' >Last</a></li>";
                } else if ($last_btn) {
                    $msg .= "<li p='$no_of_paginations'  ><a href='#' >Last</a></li>";
                }
                $msg = $msg . "</ul></div><div id='show_content_attribut'></div>";  // Content for pagination

                if ($no_of_paginations > 1)
                return $msg;

         return false;
  }
}