<?php

/**
* UBY_catalog_dispatcher
*
* @uses     
*
* @category Category
* @package  Package
* @author   UbyMedia
* @license  
* @link     
*/
class UBY_catalog_dispatcher extends UBY_TUNINGFILES_CATALOG_PLUGIN
{
    
    private $CHIP_API_KEY        = '';
    private $CHIP_API_SECRET     = '';
    public  $catalogConfig       = null;
    
    
    public  $response            = array('status'=> 'success');
    public  $vehicule_type       = "";
    public  $mark                = "";
    public  $model               = "";
    public  $year                = "";
    public  $engine              = "";
    public  $hpower              = "";
    public  $power               = "";
    public  $price_ht            = "";
    public  $price_ttc           = "";
    public  $preview_list        = array();
    
    public  $vehicule_type_list  = null;
    public  $simp_vehicule_type  = null;
    public  $show_vehicule_type  = true;
    public  $expect_display_lang = true;
    
    public  $carData             = null;
    public  $markList            = null;
    public  $motorsList          = null;
    public  $modelList           = null;
    public  $productionYearList  = null;
    public  $arrayPoint          = null;
    public  $meta_title          = "initial";
    public  $end_title           = "";
    
    public  $editedCalalog       = null;
    public  $unpublishedVehicle  = null;
    public  $unpublishedVehicles  = null;
    
    public $string             = array(
        
        "w_lbl_standard"   => array(
            "de"               => "Standard",
            "en"               => "Standard",
            "es"               => "Estándar",
            "fr"               => "Standard",
            "it"               => "Standard",
            "pt"               => "Padrão",
            "ru"               => "стандарт"
        ),
        "w_lbl_difference" => array(
            "de"               => "Unterschied",
            "en"               => "Difference",
            "es"               => "Diferencia",
            "fr"               => "Différence",
            "it"               => "Differenza",
            "pt"               => "Diferença",
            "ru"               => "разницаs"
        
        ),
        "w_lbl_HP"     => array(
            "de"               => "HP",
            "en"               => "HP",
            "es"               => "HP",
            "fr"               => "CV",
            "it"               => "HP",
            "pt"               => "HP",
            "ru"               => "HP",
        
        ),
        "w_lbl_HP_unit"     => array(
            "de"               => "Hp",
            "en"               => "Hp",
            "es"               => "Hp",
            "fr"               => "Cv",
            "it"               => "Hp",
            "pt"               => "Hp",
            "ru"               => "Hp",
        
        ),
        "w_lbl_Torque"     => array(
            "de"               => "Drehmoment",
            "en"               => "Torque",
            "es"               => "Esfuerzo de torsión",
            "fr"               => "Torque",
            "it"               => "momento torcente",
            "pt"               => "Torque",
            "ru"               => "крутящий моментs"
        
        ),
        "w_lbl_Method"     => array(
            "de"               => "Methode",
            "en"               => "Method",
            "es"               => "Método",
            "fr"               => "Méthode",
            "it"               => "Metodo",
            "pt"               => "Método",
            "ru"               => "методs"
        
        ),
        "w_lbl_Options"    => array(
            "de"               => "Optionen",
            "en"               => "Options",
            "es"               => "Opciones",
            "fr"               => "Options",
            "it"               => "Opzioni",
            "pt"               => "Opções",
            "ru"               => "Опции"
        
        ),
       
        "choose_a_mark"    => array(
            "de"               => "Wählen Sie eine Marke ...",
            "en"               => "Choose a brand ...",
            "es"               => "Elija una marca ...",
            "fr"               => "Choisissez une marque ...",
            "it"               => "Scegli una marca ...",
            "pt"               => "Escolha uma marca ...",
            "ru"               => "Выберите бренд ..."
        ),
        "choose_a_model"    => array(
            "de"               => "Wähle ein Modell ...",
            "en"               => "Choose a model ...",
            "es"               => "Escoge un modelo ...",
            "fr"               => "Choisissez un modèle ...",
            "it"               => "Scegli un modello ...",
            "pt"               => "Escolha um modelo ...",
            "ru"               => "Выберите модель ...",     
        ),
        "choose_a_production_year"    => array(
            "de"               => "Wählen Sie ein Baujahr ...",
            "en"               => "Choose a year of construction ...",
            "es"               => "Elegir un año de construcción ...",
            "fr"               => "Choisissez une année de construction ...",
            "it"               => "Scegli un anno di costruzione ...",
            "pt"               => "Escolha um ano de construção ...",
            "ru"               => "Выберите год постройки ..."  
        ),
        "choose_a_engine"    => array(
            "de"               => "Wählen Sie die Art des Motors ...",
            "en"               => "Choose the type of engine ...",
            "es"               => "Elige el tipo de motor ...",
            "fr"               => "Choisissez le type de moteur ...",
            "it"               => "Scegli il tipo di motore ...",
            "pt"               => "Escolha o tipo de motor ...",
            "ru"               => "Выберите тип двигателя ..."
        ),
        "no_result"    => array(
            "de"               => "keine Ergebnisse gefunden",
            "en"               => "No results found",
            "es"               => "No se han encontrado resultados",
            "fr"               => "Aucun résultat trouvé",
            "it"               => "nessun risultato trovato",
            "pt"               => "Nenhum resultado encontrado",
            "ru"               => "результатов не найдено",                          
        ),
        "tuningfilesviewer_title"    => array(
            "de"               => "Tuning-Dateien",
            "en"               => "Tuning Files",
            "es"               => "Sintonización de archivos",
            "fr"               => "Fichiers Tuning",
            "it"               => "Sintonizzazione dei file",
            "pt"               => "Sintonizando arquivos",
            "ru"               => "Настройка файлов"                     
        ),
        "vehicule_type_title_choise"    => array(
            "de"               => "Wählen Sie die Art des Fahrzeugs",
            "en"               => "Choose the type of vehicle",
            "es"               => "Elegir el tipo de vehículo",
            "fr"               => "Choisissez le type de véhicule",
            "it"               => "Scegli il tipo di veicolo",
            "pt"               => "Escolha o tipo de veículo",
            "ru"               => "Выберите тип транспортного средства",
        ),
        "TFV_graph_axeY_name"    => array(
            "de"               => "Leistungssteigerung",
            "en"               => "Power increase",
            "es"               => "Aumento de potencia",
            "fr"               => "Augmentation de la puissance",
            "it"               => "Aumento di potenza",
            "pt"               => "Aumento de potência",
            "ru"               => "Увеличение мощности",                        
        ),
        "fileservice_label_horsepower"    => array(
            "de"               => "Leistung",
            "en"               => "Power",
            "es"               => "Poder",
            "fr"               => "Puissance",
            "it"               => "Energia",
            "pt"               => "Poder",
            "ru"               => "Мощность",           
        ),
        "home"    => array(
            "de"               => "Zuhause",
            "en"               => "Home",
            "es"               => "Casa",
            "fr"               => "Accueil",
            "it"               => "Casa",
            "pt"               => "Casa",
            "ru"               => "Главная" 
        ),
        "up_to"    => array(
            "de"               => "Mehr ",
            "en"               => "From ",
            "es"               => "Más de ",
            "fr"               => "Plus de ",
            "it"               => "su ",
            "pt"               => "Mais ",
            "ru"               => "по " 
        ),

    );

    public function __construct($preview_list = array() , $params = array() )
    {
       
        $this->preview_list  = $preview_list; 
        $this->vehicule_type = $params['vehicule_type'];
        $this->mark          = $params['mark'];
        $this->model         = $params['model'];
        $this->year          = $params['year'];
        $this->engine        = $params['engine'];
        $this->hpower        = $params['hpower']; 
        $this->power         = $params['power'];

            
        
        // if (!empty($preview_list)):
        $this->__publish_tuningfiles_catalog();
        // $blogname = get_bloginfo();
        // $this->meta_title .= " - ".$blogname;

        // echo $this->meta_title;
        /** edit the current title  */
        add_filter('pre_get_document_title', function(){ return $this->meta_title ;  }, 20) ;       
        // endif;
    }
 
    public function __publish_tuningfiles_catalog( )
    {
    	global $wpdb;
    	 

     

		$this->catalogConfig = $wpdb->get_results( 
					"SELECT * FROM {$wpdb->prefix}tuningfiles_catalog
					 WHERE  id=1" , 'ARRAY_A');	
        $this->catalogConfig = $this->catalogConfig[0];
        
        

		/**
         * CONFIG API */
        $this->CHIP_API_KEY    = $this->catalogConfig['api_key'];
        $this->CHIP_API_SECRET = $this->catalogConfig['api_secret'];

 
         
        

        /* default meta title */ 
        $this->end_title = ($this->catalogConfig['catalog_name']!='') ? $this->catalogConfig['catalog_name'] : $this->string['tuningfilesviewer_title'][$this->catalogConfig['display_lang']];
        $this->end_title .=" - ".get_bloginfo();
        $this->meta_title = $this->end_title;

        /** @var Currency_code */

        $this->currency_codes         = $this->currency_codes;
        $this->selected_currency_code = $this->catalogConfig['currency_code'];
        $this->vehicule_type_list     = $this->tfc_getVechileTypes();

           
        // if ($_SERVER['REMOTE_ADDR']=='41.98.105.40'){
        //     echo 'this->CHIP_API_KEY =>'.$this->CHIP_API_KEY."<=<br>";
        //     echo 'this->CHIP_API_SECRET =>'.$this->CHIP_API_SECRET."<=<br>";

        // }


        if ($this->vehicule_type_list['status']=='0' ) {
            $this->simp_vehicule_type  = $this->simplify_vehiculetype_list($this->vehicule_type_list);
            // Show vehicle type list or more details on a mark 
            $this->displayedVehiculesTypes = json_decode( $this->catalogConfig['displayed_vehicules_types'] , true);
             
            if ($this->vehicule_type_list['status']=='0') 
                if (isset($this->vehicule_type) AND array_key_exists($this->vehicule_type, $this->simp_vehicule_type)) $this->show_vehicule_type = false ;


            $this->expect_display_lang = (isset($this->catalogConfig['display_lang']) AND in_array($this->catalogConfig['display_lang'], array('fr' , 'en'))) ? $this->catalogConfig['display_lang'] : 'en' ; 
             

            if (!$this->show_vehicule_type):
                if ($this->preview_list['details']) { 

                    $dataTuningFile_year  = explode('-', $this->year);
                                                         
                    $this->carData = $this->sbs_getCarDetails( array(
                        'vehicule_type' => $this->vehicule_type,
                        'mark'          => $this->mark,
                        'model'         => $this->model,
                        'engine'        => $this->engine,
                        'horsepower'    => $this->hpower,
                        'yfrom'         => $dataTuningFile_year[0],
                        'yto'           => $dataTuningFile_year[1],
                        'power'         => $this->power,
                        ));
                   
                    $this->carData = $this->carData['data'];
                    $this->arrayPoint = preg_split('/\r\n|[\r\n]/', $this->carData[0]['points'][$this->expect_display_lang]);
                 
                    /** Replace all words of Api company with your company name (if not empty ) */
                    if (isset($this->catalogConfig['company_name']) AND $this->catalogConfig['company_name']!='') {

                        $this->carData[0]['description']['fr'] = preg_replace("/(Mod-files.com)|(mod-files.com)|(MOD-FILES.COM)|(mod-files)|(Mod-Files.com)/", $this->catalogConfig['company_name'] , $this->carData[0]['description']['fr']);

                        $this->carData[0]['description']['en'] = preg_replace("/(Mod-files.com)|(mod-files.com)|(MOD-FILES.COM)|(mod-files)|(Mod-Files.com)/", $this->catalogConfig['company_name'] , $this->carData[0]['description']['en']);
                    
                    }
                    $this->motorsList = $this->sbs_getMotors( array(
                        'vehicule_type' => $this->vehicule_type,
                        'mark'          => $this->mark,
                        'model'         => $this->model,
                        'yfrom'         => $dataTuningFile_year[0],
                        'yto'           => $dataTuningFile_year[1],
                        ));

                    
                    $this->motorsList = $this->motorsList['data'];  
                    /** get only motors id  */
                    $motors_ids = array_reduce($this->motorsList , function($element , $item){

                        $element[] = $item['id'];
                        return $element;
                    }); 
                    

                    $this->unpublishedVehicles = $this->getUnpublishedVehicles($motors_ids);
                        
                   
                    /** GENERATE PAGE TITLE */
                    $this->meta_title = $this->carData[0]['mark']['name']." ".$this->carData[0]['model']['name']." ".$this->carData[0]['horsepower']['name']." ".((isset($this->carData[0]['engine']['name']) AND $this->carData[0]['engine']['name']!='') ? $this->carData[0]['engine']['name'] : '' )." ".$this->carData[0]['hp']['standard']." | ".$this->string['tuningfilesviewer_title'][$this->catalogConfig['display_lang']];
                    $this->meta_title .= " - ".$this->end_title;
                    /** PRICI CALCULATE  */
                    $TVA = $this->catalogConfig['tva_payment'];
                    preg_match('/([0-9])+/' , $this->carData[0]['hp']['standard'] , $hp_standard_tmp);
                    preg_match('/([0-9])+/' , $this->carData[0]['torque']['standard'] , $torque_standard_tmp);
                    
                    preg_match('/([0-9])+/' , $this->carData[0]['hp']['system'] , $hp_system_tmp);
                    preg_match('/([0-9])+/' , $this->carData[0]['torque']['system'] , $torque_system_tmp);
                    
                    $this->carData[0]['hp']['standard']     = $hp_standard_tmp[0];
                    $this->carData[0]['torque']['standard'] = $torque_standard_tmp[0];
                    
                    $this->carData[0]['hp']['system']     = $hp_system_tmp[0];
                    $this->carData[0]['torque']['system'] = $torque_system_tmp[0];

                    $this->carData[0]['hp']['difference']     = floatval($hp_system_tmp[0]) - floatval($hp_standard_tmp[0]);
                    $this->carData[0]['torque']['difference'] = floatval($torque_system_tmp[0]) - floatval($torque_standard_tmp[0]);
                    
                    $this->price_ht = 0 ; // init 
                    $this->price_ttc = 0 ; // init 
                    /** Unpublished vehicle :  */
                    $unpublishedVehicle = $wpdb->get_row(
                                            "SELECT * 
                                            FROM {$wpdb->prefix}tuningfiles_unpublished_vehicules 
                                            WHERE api_vehicule_id=".$this->carData[0]['id'] , ARRAY_A  );

                    $this->unpublishedVehicle = $unpublishedVehicle;
                    /** @var Edited Vehicles Data */
                    $editedCalalog = $wpdb->get_row(
                                            "SELECT * 
                                            FROM {$wpdb->prefix}tuningfiles_edited_vehicules 
                                            WHERE api_vehicule_id=".$this->carData[0]['id'] , ARRAY_A  );

                     
                    $this->editedCalalog = $editedCalalog;
                    if (isset($editedCalalog) AND !empty($editedCalalog)):
                        /** * Edited Hp and torque */
                        if(isset($editedCalalog['bhp_system']) AND $editedCalalog['bhp_system']!=''):
                            $this->carData[0]['hp']['system']     = $editedCalalog['bhp_system'];
                            $this->carData[0]['hp']['difference'] = floatval($editedCalalog['bhp_system']) - floatval($hp_standard_tmp[0]);
                        endif;

                        if(isset($editedCalalog['torque_system']) AND $editedCalalog['torque_system']!=''):
                            $this->carData[0]['torque']['system']     = $editedCalalog['torque_system'];
                            $this->carData[0]['torque']['difference'] = floatval($editedCalalog['torque_system']) - floatval($torque_standard_tmp[0]);
                        endif;
                        
                    endif;

                    if (isset($editedCalalog) AND !empty($editedCalalog) AND $editedCalalog['price_ht']!=null):
                        /** 1. Check default local price - vehicule  */
                        $this->price_ht = $editedCalalog['price_ht'];
                        $this->price_ttc = floatval(floatval($editedCalalog['price_ht']) * (1+($TVA/100)));
                    /** 2. Check Pricing Rules */
                    else:
                        $appliedPricingRules = $wpdb->get_results( 
                            "SELECT * FROM {$wpdb->prefix}tuningfiles_pricing_rules
                             WHERE  1=1
                             AND ( (vehicule_type_permalink IS NULL) OR ( vehicule_type_permalink is NOT NULL AND vehicule_type_permalink = '{$this->carData[0]['type']['id']}' ) )
                             AND ( (mark_permalink IS NULL) OR ( mark_permalink is NOT NULL AND mark_permalink = '{$this->carData[0]['mark']['id']}' ) )
                             AND ( (model_permalink IS NULL) OR ( model_permalink is NOT NULL AND model_permalink = '{$this->carData[0]['model']['id']}' ) )
                              
                             AND ((min_year IS NULL) OR ( min_year is NOT NULL AND min_year <= {$this->carData[0]['production_year']['start']} ))
                             AND ((max_year IS NULL) OR ( max_year IS NOT NULL AND {$this->carData[0]['production_year']['end']} <= max_year ) )
                             AND ((min_original_puissance IS NULL) OR ( min_original_puissance is NOT NULL AND min_original_puissance <= {$this->carData[0]['hp']['standard']} ))
                             AND ((max_original_puissance IS NULL) OR ( max_original_puissance IS NOT NULL AND {$this->carData[0]['hp']['standard']} <= max_original_puissance ) )
                             AND ((min_original_torque IS NULL) OR ( min_original_torque is NOT NULL AND min_original_torque <= {$this->carData[0]['torque']['standard']} ))
                             AND ((max_original_torque IS NULL) OR ( max_original_torque IS NOT NULL AND {$this->carData[0]['torque']['standard']} <= max_original_torque ) )

                             AND status='activated' 
                                ORDER BY order_no ASC" ,


                            'ARRAY_A');
                            
                        if (isset($appliedPricingRules) AND !empty($appliedPricingRules)):
                            
                            $this->price_ht = $appliedPricingRules[0]['price_ht'];
                            $this->price_ttc = floatval(floatval($appliedPricingRules[0]['price_ht']) * (1+($TVA/100)));
                      
                        endif;
                    endif;

                    

                     

                }else if ($this->preview_list['motor'] OR $this->preview_list['year'] OR $this->preview_list['model']) {

                    $this->meta_title = "";
                    if ( $this->preview_list['model'] OR $this->preview_list['year'] OR $this->preview_list['motor'] OR $this->preview_list['details']) {
                                                                
                                         
                        $this->modelList = $this->sbs_getModels( array(
                            'vehicule_type' => $this->vehicule_type,
                            'mark'          => $this->mark,
                            ));
                         
                        $this->modelList = $this->modelList['data'];

                        $this->meta_title .= $this->modelList[0]['mark']['name'];

                    }
                    if ( $this->preview_list['year'] OR $this->preview_list['motor'] OR $this->preview_list['details']) {

                        $this->productionYearList = $this->sbs_getProductionYear( array(
                            'vehicule_type' => $this->vehicule_type,
                            'mark'          => $this->mark,
                            'model'         => $this->model,
                            ));

                        $this->productionYearList = $this->productionYearList['data'];
                        $this->meta_title .= $this->productionYearList[0]['model']['name']." ";

                    }
                    if ($this->preview_list['motor'] OR $this->preview_list['details']) {

                        $dataTuningFile_year  = explode('-', $this->year);
                         
                        $this->motorsList = $this->sbs_getMotors( array(
                            'vehicule_type' => $this->vehicule_type,
                            'mark'          => $this->mark,
                            'model'         => $this->model,
                            'yfrom'         => $dataTuningFile_year[0],
                            'yto'           => $dataTuningFile_year[1],
                            ));

                        
                        $this->motorsList = $this->motorsList['data'];  
                        $this->meta_title .=   ($this->motorsList[0]['production_year']['end'] AND $this->motorsList[0]['production_year']['end'] > 0 ) ? $this->motorsList[0]['production_year']['start'].' > '.$this->motorsList[0]['production_year']['end'] :  $this->string['up_to'][$this->catalogConfig['display_lang']].$this->motorsList[0]['production_year']['start'];
                    
                        /** get only motors id  */
                        $motors_ids = array_reduce($this->motorsList , function($element , $item){

                            $element[] = $item['id'];
                            return $element;
                        }); 
                        

                        $this->unpublishedVehicles = $this->getUnpublishedVehicles($motors_ids);
                        
                        

                    } 

                    /** GENERATE PAGE TITLE */
                    $this->meta_title .= " - ".$this->end_title;



                }else {
                    $this->markList = $this->sbs_getMarks( array(
                                    'vehicule_type' => $this->vehicule_type
                                    ));

                    /** GENERATE PAGE TITLE */
                    $this->meta_title =   $this->simp_vehicule_type[$this->vehicule_type][$this->catalogConfig['display_lang']];
                    $this->meta_title .= " - ".$this->end_title;
                }
            else:
                /** GENERATE PAGE TITLE */
                
                $this->meta_title =  $this->end_title;
            endif;
        }
       
       
       
        

   	}


    /**
     * simplify_vehiculetype_list
     * 
     * @param array $tab Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
   	public function simplify_vehiculetype_list($tab = array()){

        
        if (!isset($tab) OR empty($tab)) return false;

        $response = array();
        foreach ($tab['data'] as $key => $value) {
            $response[$value['type']['id']] = $value['type']['name'];
        }

        return $response;

    }



   	/**
     * tfc_getVechileTypes
     * 
     * @access public
     *
     * @return mixed Value.
     */
    public function tfc_getVechileTypes(){

        

            $url = 'https://www.mod-files.com/api/chip/v1/types?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'sort'       => 'type',
            ]);

            if ($_SERVER['REMOTE_ADDR']=='41.98.105.40'){
                echo $url;

            }
        

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);

             
            error_log($response);
            return json_decode($response , true);
 
            


            
        
        return false;


    }


    /**
     * sbs_getMarks
     * 
     * @param array $data Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
  	public function sbs_getMarks($data = array()){

        if (isset($data['vehicule_type']) AND $data['vehicule_type']!=''){

            $url = 'https://www.mod-files.com/api/chip/v1/types/'.$data['vehicule_type'].'/marks?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'logo',
                'sort'       => 'mark',
            ]);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            error_log($response);
            return json_decode($response , true);

           return $response;


            
        }
        return false;


    }

    /**
     * sbs_getModels
     * 
     * @param array $data Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
    public function sbs_getModels($data = array()){

        $_link_adapter = "";
        if (isset($data['vehicule_type']) AND $data['vehicule_type']!='') $_link_adapter .= "types/".$data['vehicule_type']."/";
        if (isset($data['mark']) AND $data['mark']!='') $_link_adapter .= "marks/".$data['mark']."/";

            $url = 'https://www.mod-files.com/api/chip/v1/'.$_link_adapter.'models?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'logo,mark,model',
                 'sort'       => 'model',
            ]);

            

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            // error_log($response);

            return json_decode($response , true);

       
        return false;


    }

    /**
     * sbs_getProductionYear
     * 
     * @param array $data Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
    public function sbs_getProductionYear($data = array()){

        $_link_adapter = "";
        if (isset($data['vehicule_type']) AND $data['vehicule_type']!='') $_link_adapter .= "types/".$data['vehicule_type']."/";
        if (isset($data['mark']) AND $data['mark']!='') $_link_adapter .= "marks/".$data['mark']."/";
        if (isset($data['model']) AND $data['model']!='') $_link_adapter .= "models/".$data['model']."/";

            $url = 'https://www.mod-files.com/api/chip/v1/'.$_link_adapter.'yfrom?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'logo,mark,model,model_type',
                'sort'     => 'production_start_year',
            ]);

            

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            // error_log($response);

            return json_decode($response , true);

       
        return false;


    }
    public function sbs_getMotors($data = array()){

        $_link_adapter = "";
        $sort          ="";

        if (isset($data['vehicule_type']) AND $data['vehicule_type']!='') { $_link_adapter .= "types/".$data['vehicule_type']."/";   }
        if (isset($data['mark']) AND $data['mark']!='') { $_link_adapter .= "marks/".$data['mark']."/"; $sort ="mark"; }
        if (isset($data['model']) AND $data['model']!='') { $_link_adapter .= "models/".$data['model']."/"; $sort ="model"; }
        if (isset($data['yfrom']) AND $data['yfrom']!='') { $_link_adapter .= "yfrom/".$data['yfrom']."/"; $sort ="production_start_year"; }
        if (isset($data['yto']) AND $data['yto']!='') { $_link_adapter .= "yto/".$data['yto']."/"; $sort ="production_end_year"; }

            $url = 'https://www.mod-files.com/api/chip/v1/'.$_link_adapter.'?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'id,logo,mark,model,engine,horsepower,hp',
                'sort'       => $sort
            ]);

           // echo $url;  

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            // error_log($response);

            return json_decode($response , true);

       
        return false;


    }


    /**
     * sbs_getCarDetails
     * 
     * @param array $data Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
    public function sbs_getCarDetails($data = array()){

        $_link_adapter = "";
        if (isset($data['vehicule_type']) AND $data['vehicule_type'] !='') $_link_adapter .= "types/".$data['vehicule_type']."/";
        if (isset($data['mark']) AND $data['mark']                   !='') $_link_adapter .= "marks/".$data['mark']."/";
        if (isset($data['model']) AND $data['model']                 !='') $_link_adapter .= "models/".$data['model']."/";
        if (isset($data['yfrom']) AND $data['yfrom']                 !='') $_link_adapter .= "yfrom/".$data['yfrom']."/";
        if (isset($data['yto']) AND $data['yto']                     !='') $_link_adapter .= "yto/".$data['yto']."/";
        if (isset($data['engine']) AND $data['engine']               !='') $_link_adapter .= "engines/".$data['engine']."/";
        if (isset($data['horsepower']) AND $data['horsepower']       !='') $_link_adapter .= "horsepowers/".$data['horsepower']."/";
        if (isset($data['power']) AND $data['power']                 !='') $_link_adapter .= "powers/".$data['power']."/";

            $url = 'https://www.mod-files.com/api/chip/v1/'.$_link_adapter.'?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'id,type,mark,model,engine,model_type,horsepower,hp,torque,production_start_year,production_end_year,image,images,description,points',
            ]);

           

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            // error_log($response);

            return json_decode($response , true);

       
        return false;


    }
    /**
     * [getUnpublishedVehicles description]
     * @param  array  $motors_ids [description]
     * @return [type]             [description]
     */
    public function getUnpublishedVehicles($motors_ids = array()){

        global $wpdb;

        if (!isset($motors_ids) OR empty($motors_ids)) return false;
        
        $motors_ids = implode(',', $motors_ids);


        $unpublishedVehicles = $wpdb->get_results(
                            "SELECT api_vehicule_id 
                            FROM {$wpdb->prefix}tuningfiles_unpublished_vehicules 
                            WHERE api_vehicule_id IN (".$motors_ids.")" , ARRAY_A  );

        $unpublishedVehicles = array_reduce($unpublishedVehicles , function($element , $item){

            $element[] = $item['api_vehicule_id'];
            return $element;
        });
        return $unpublishedVehicles;
        // $this->unpublishedVehicle = $unpublishedVehicle;
        // echo '<pre>';
        // print_r($unpublishedVehicle);
        // echo '</pre>';
    }

}
