<!doctype html>
<html lang="{$language.iso_code}">
<head>
  {if $meta_title}<title>{block name='head_seo_title'}{$meta_title}{/block}</title>{/if}
  {block name='head'}{include file='_partials/head.tpl'}{/block}
  
  
</head>
<body id="{$page.page_name}" class="{$page.body_classes|classnames}">
  {hook h='displayAfterBodyOpeningTag'}
  <main>
    <header id="header">
      {block name='header'}
        {include file='_partials/header.tpl'}
      {/block}
    </header>
    <section id="wrapper">
      <div class="container">      
        <div class="tuning-files-catalog" {if $opt_display_style_margin_top > 0 }style="margin-top:{}px"{/if} >
          <nav data-depth="2" class="breadcrumb hidden-sm-down">
          <ol itemscope="" itemtype="http://schema.org/BreadcrumbList">  
            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
              <a itemprop="item" href="{$WEBROOT}">
                <span itemprop="name">{$string.home[$opt_display_lang]}</span>
              </a>
              <meta itemprop="position" content="1">
            </li>
            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
              <a itemprop="item" href="{$MODULE_INDEX_URL}">
                <span itemprop="name">{if $opt_display_catalog_name!=''}{$opt_display_catalog_name}{else}{$string.tuningfilesviewer_title[$opt_display_lang]}{/if}</span>
              </a>
              <meta itemprop="position" content="2">
            </li>
            {if !$show_vehicule_type }
            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
              <a itemprop="item" href="{$MODULE_INDEX_URL}{$vehicule_type}">
                <span itemprop="name">{$vehicule_type_list[$vehicule_type][$opt_display_lang]}</span>
              </a>
              <meta itemprop="position" content="2">
            </li>
            {/if}
            {if  $preview_list.model OR $preview_list.year OR $preview_list.motor OR $preview_list.details}
            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
              <a itemprop="item" href="{$MODULE_INDEX_URL}{$vehicule_type}/{$modellist[0].mark.id}">
                <span itemprop="name">{$modellist[0].mark.name}</span>
              </a>
              <meta itemprop="position" content="2">
            </li>
            {/if}
            {if  $preview_list.year OR $preview_list.motor  OR $preview_list.details}
            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
              <a itemprop="item" href="{$MODULE_INDEX_URL}{$vehicule_type}/{$modellist[0].mark.id}/{$productionYearList[0].model.id}">
                <span itemprop="name">{$productionYearList[0].model.name}</span>
              </a>
              <meta itemprop="position" content="2">
            </li>
            {/if}
            {if $preview_list.motor  OR $preview_list.details}
            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
              <a itemprop="item" href="{$MODULE_INDEX_URL}{$vehicule_type}/{$modellist[0].mark.id}/{$productionYearList[0].model.id}/{$motorsList[0].production_year.start}-{$motorsList[0].production_year.end}">
                <span itemprop="name">{if $motorsList[0].production_year.end AND $motorsList[0].production_year.end > 0 } {$motorsList[0].production_year.start} > {$motorsList[0].production_year.end}
                {else}  {$string.up_to[$opt_display_lang]}{$motorsList[0].production_year.start}
                {/if}</span>
              </a>
              <meta itemprop="position" content="2">
            </li>
            {/if}
          </ol>
          </nav>
          {block name="content_wrapper"}
            <div id="content-wrapper">  
              {block name="content"}
                {* STYLE DESIGN OPTIONS : FONT COLOR *}
                {if $opt_display_style_font_color}
                {literal}<style type="text/css"> .cars-display *{color:{/literal}{$opt_display_style_font_color}{literal}!important;}</style>{/literal}
                {/if}
                {* STYLE DESIGN OPTIONS : BACKGROUND COLOR *}
                {if $opt_display_style_background_color}
                {literal}<style type="text/css"> .cars-display{background-color:{/literal}{$opt_display_style_background_color}{literal}!important;}</style>{/literal}
                {/if}
                {if $response.status eq 'success'}  
                
                  {if !$show_vehicule_type }
                  <div class='cars-display'>
                    {if   $preview_list.details eq '1' }
                    <div class='cd  display-grid details-table'>
                      <div class='cd-title'>
                        <span class='v_type {if $vehicule_type=="trucks"}blue{else}orange{/if}'>{$vehicule_type_list[$vehicule_type][$opt_display_lang]}</span>
                        <span>{$carData[0].mark.name} {$carData[0].model.name} {$carData[0].horsepower.name} {((isset($carData[0].engine.id) and $carData[0].engine.id!='') ? $carData[0].engine.name : '')} {$carData[0].hp.standard}</span>
                      </div>
                      <div class='cd-inner'>
                        <ul class='block-grid'> 
                         <li>
                            {if $opt_display_style_photo == true }     
                            <div class="rt img">
                              {if isset($carData[0].image) AND $carData[0].image!='' }
                              <img src="{$carData[0].image}" alt="{if $opt_display_catalog_name!=''}{$opt_display_catalog_name}{else}{$string.tuningfilesviewer_title[$opt_display_lang]}{/if} {$carData[0].mark.name} {$carData[0].model.name} {$carData[0].horsepower.name} {((isset($carData[0].engine.id) and $carData[0].engine.id!='') ? $carData[0].engine.name : '')} {$carData[0].hp.standard}">
                              {/if} 
                            </div>
                            {/if} 
                            <article>
                              <header class='small'>
                                <h2>
                                {if $motorsList[0].production_year.end AND $motorsList[0].production_year.end > 0} 
                                {$motorsList[0].production_year.start} > {$motorsList[0].production_year.end}
                                {else} {$string.up_to[$opt_display_lang]}{$motorsList[0].production_year.start}
                                {/if}
                                </h2>
                              </header>
                              <ul class='content'>
                                {foreach from=$motorsList item=itemMotor}
                                    <li><a href="{$MODULE_INDEX_URL}{$vehicule_type}/{$itemMotor.mark.id}/{$itemMotor.model.id}/{$itemMotor.production_year.start}-{$itemMotor.production_year.end}/{if isset($itemMotor.engine.id) AND $itemMotor.engine.id!=''}{$itemMotor.engine.id}{else}-{/if}/{$itemMotor.horsepower.id}/{$itemMotor.hp.standard}">
                                      <span>{$itemMotor.horsepower.name} {((isset($itemMotor.engine.id) and $itemMotor.engine.id!='') ? $itemMotor.engine.name : '')}</span>
                                      <span class='cv'>{$itemMotor.hp.standard}</span>
                                    </a>
                                  </li>  
                                {/foreach}
                              </ul>
                            </article>
                          </li>
                          <li class='detail-motor'>
                            {if $opt_display_style_long_description == true }
                            <p>{$carData[0].description[$expect_display_lang]}</p> 
                            {/if}    
                            {if $opt_display_style_chart == true }                        
                            <script type='text/javascript' src='https://www.mod-files.com/lib/amcharts-graph-v2/amcharts.js?v='></script>
                            <script type='text/javascript' src='https://www.mod-files.com/lib/amcharts-graph-v2/serial.js?v='></script>
                            <script type='text/javascript' src='https://www.mod-files.com/lib/amcharts-graph-v2/light.js?v='></script>
                            <script type='text/javascript' src='https://www.mod-files.com/lib/amcharts-graph-v2/responsive.min.js?v='></script>
                            <script type='text/javascript' src='https://www.mod-files.com/lib/amcharts-graph-v2/export.js?v='></script>
                            <link type='text/css' rel='stylesheet' href='https://www.mod-files.com/lib/amcharts-graph-v2/export.css?v=' media='all' />
                            <div id="chart-stages" style="width: 100%;height: 320px;overflow: hidden;text-align: left;background: rgba(246, 246, 246, 0.98);border-bottom: 1px dashed rgba(194, 194, 194, 0.58);"></div>
                            <script type="text/javascript">
                              AmCharts.makeChart("chart-stages",
                                {
                                  "type": "serial",
                                  "categoryField": "category",
                                  
                                  "angle": 30,
                                  "depth3D": 15,
                                  "startDuration": 1,
                                  "startEffect": "bounce",
                                  "theme": "light",
                                  "categoryAxis": {
                                    "gridPosition": "start"
                                  },
                                  "trendLines": [],
                                  "graphs": [
                                    {
                                      "balloonText": "[[title]] - [[value]] hp",
                                      "fillAlphas": 1,
                                      "id": "AmGraph-1",
                                      "title": "{$string.fileservice_label_horsepower[$opt_display_lang]} ( HP )",
                                      "type": "column",
                                      "valueField": "column-1"
                                    },
                                    {
                                      "balloonText": "[[title]] - [[value]] Nm",
                                      "fillAlphas": 1,
                                      "id": "AmGraph-2",
                                      "title": "{$string.w_lbl_Torque[$opt_display_lang]}",
                                      "type": "column",
                                      "valueField": "column-2"
                                    }
                                  ],
                                  "guides": [],
                                  "valueAxes": [
                                    {
                                      "id": "ValueAxis-1",
                                       minimum: 0,
                                      "title": "{$string.TFV_graph_axeY_name[$opt_display_lang]}"
                                    }
                                  ],
                                  "allLabels": [],
                                  "balloon": {},
                                  "responsive": {
                                    "enabled": false
                                  },
                                  "export": {
                                    "enabled": false
                                  },
                                  "legend": {
                                    "enabled": false,
                                    "useGraphSettings": true
                                  },
                                  "dataProvider": [
                                    {
                                      "category": "{$string.w_lbl_standard[$opt_display_lang]}",
                                      "column-1": "{$output_hp_standard[0]}",
                                      "column-2": "{$output_torque_standard[0]}"
                                    },
                                    {
                                      "category": "{$opt_display_company_name}",
                                      "column-1": "{$output_hp_system[0]}",
                                      "column-2": "{$output_torque_system[0]}"
                                    }
                                  ]
                                }
                              );
                            </script>
                            {/if}    
                            <table width="100%" border="0" cellspacing="5" cellpadding="0" class="stage-data">
                              <tbody>
                                <tr>
                                  <th scope="col" class="empty">&nbsp;</th>
                                  <th scope="col">{$string.w_lbl_standard[$opt_display_lang]}</th>
                                  <th scope="col">{$opt_display_company_name}</th>
                                  <th scope="col">{$string.w_lbl_difference[$opt_display_lang]}</th>
                                </tr>
                                <tr>
                                  <th scope="row">HP</th>
                                  <td>{$carData[0].hp.standard}</td>
                                  <td class="highlight info" >{$carData[0].hp.system}</td>
                                  <td class="highlight info" >+ {$carData[0].hp.difference}</td>
                                </tr>
                                <tr>
                                  <th scope="row">{$string.w_lbl_Torque[$opt_display_lang]}</th>
                                  <td>{$carData[0].torque.standard}</td>
                                  <td class="highlight">{$carData[0].torque.system}</td>
                                  <td class="highlight">+ {$carData[0].torque.difference}</td>
                                </tr>
                                {*<tr>
                                  <td>{$string.w_lbl_Method[$opt_display_lang]}</td>
                                  <td colspan='3'>{$carData[0].method}<td/>
                                </tr>
                                <tr>
                                  <td>{$string.w_lbl_Options[$opt_display_lang]}</td>
                                  <td colspan='3'>{$carData[0].options}<td/>
                                </tr>*}
                              </tbody>
                            </table>
                            {if $opt_display_style_sub_items == true }  
                            <div class="seconde-section">
                              <div class="lf">
                                <h2>{if $opt_display_catalog_name!=''}{$opt_display_catalog_name}{else}{$string.tuningfilesviewer_title[$opt_display_lang]}{/if} {$carData[0].mark.name} {$carData[0].model.name} {$carData[0].horsepower.name} {((isset($carData[0].engine.id) and $carData[0].engine.id!='') ? $carData[0].engine.name : '')} {$carData[0].hp.standard}</h2>
                                  {if count($arrayPoint) > 1}
                                    <ul>
                                    {foreach from=$arrayPoint item=value}
                                        <li>{$value}</li>
                                    {/foreach}
                                    </ul>
                                {/if}
                              </div>
                            </div>
                            {/if}
                          </li>
                        </ul>
                      </div>
                    </div>
                    {elseif $preview_list.motor OR $preview_list.year OR $preview_list.model }
                    <div class='cd  display-grid'>
                      <div class='cd-title'>
                        <span>
                        {if $preview_list.model} {$string.choose_a_model[$opt_display_lang]}
                        {elseif $preview_list.year}  {$string.choose_a_production_year[$opt_display_lang]}
                        {elseif $preview_list.motor} {$string.choose_a_engine[$opt_display_lang]}
                        {/if}
                        </span>
                      </div>
                      <div class='cd-inner'>
                        <ul class='block-grid'>
                          {if  $preview_list.model OR $preview_list.year OR $preview_list.motor}
                            <li>
                              <article>
                                <header>
                                  <h2>{$modellist[0].mark.name}</h2>
                                  <img src="{$modellist[0].logo.thumb}" width="70">
                                </header>
                                <ul class='content'>
                                  {if count($modellist)}
                                    {foreach from=$modellist item=itemmodel}
                                      <li><a href="{$MODULE_INDEX_URL}{$vehicule_type}/{$itemmodel.mark.id}/{$itemmodel.model.id}">{$itemmodel.model.name}</a></li>  
                                    {/foreach} 
                                  {else}<li><div class="alert warning">{$string.no_result[$opt_display_lang]}</div></li>{/if}
                                </ul>
                              </article>
                            </li>
                          {/if}
                          {if  $preview_list.year OR $preview_list.motor }
                            <li>
                              <article>
                                <header>
                                  <h2>{$productionYearList[0].model.name}</h2>
                                  <img src="{$productionYearList[0].logo.thumb}" width="70">
                                </header>
                                <ul class='content'>
                                  {if count($productionYearList)}
                                    {foreach from=$productionYearList item=itemyear}
                                      <li><a href="{$MODULE_INDEX_URL}{$vehicule_type}/{$itemyear.mark.id}/{$itemyear.model.id}/{$itemyear.production_year.start}-{$itemyear.production_year.end}">  
                                         
                                        {if $itemyear.model_type}{$itemyear.model_type.name}{/if}
                
                                        {if  $itemyear.production_year.end and $itemyear.production_year.end > 0} {$itemyear.production_year.start} > {$itemyear.production_year.end}
                                        {else} {$string.up_to[$opt_display_lang]}{$itemyear.production_year.start}{/if} </a></li>  
                                    {/foreach}
                                  {else}<li><div class="alert warning">{$string.no_result[$opt_display_lang]}</div></li>{/if}
                                </ul>
                              </article>
                            </li>
                          {/if}
                          {if $preview_list.motor}
                            <li>
                              <article>
                                <header class='small'>
                                  <h2>
                                  {if $motorsList[0].production_year.end AND $motorsList[0].production_year.end > 0 } {$motorsList[0].production_year.start} > {$motorsList[0].production_year.end}
                                  {else}  {$string.up_to[$opt_display_lang]}{$motorsList[0].production_year.start}
                                  {/if}</h2>
                                </header>
                                <ul class='content'>
                                  {foreach from=$motorsList item=itemmotor }
                                      <li><a href="{$MODULE_INDEX_URL}{$vehicule_type}/{$itemmotor.mark.id}/{$itemmotor.model.id}/{$itemmotor.production_year.start}-{$itemmotor.production_year.end}/{((isset($itemmotor.engine.id) and $itemmotor.engine.id!='') ? $itemmotor.engine.id : '-')}/{$itemmotor.horsepower.id}/{$itemmotor.hp.standard}">
                                        <span>{$itemmotor.horsepower.name} {((isset($itemmotor.engine.id) and $itemmotor.engine.id!='') ? $itemmotor.engine.name : '')} </span>
                                        <span class='cv'>{$itemmotor.hp.standard}</span>
                                      </a>
                                    </li>  
                                  {/foreach}
                                </ul>
                              </article>
                            </li>
                          {/if}
                        </ul>
                      </div>  
                    </div> 
                    {else}  
                    <div class='cd  display-mark'>
                      <div class='cd-title'><span>{$string.choose_a_mark[$opt_display_lang]}</span></div>
                      <div class='cd-inner'>
                      {if  isset($markList) AND $markList.status==0 AND $markList.total  > 0 }
                      <ul>
                        {foreach from=$markList.data  item=item}
                        <li><a href='{$MODULE_INDEX_URL}{$vehicule_type}/{$item.mark.id}' class='it'>
                          <img src="{if isset($item.logo)}{$item.logo.thumb}{/if}">
                          <span>{$item.mark.name}</span>
                        </a></li>  
                        {/foreach}
                      </ul> 
                      {else}
                        <div class='alert warning'>{$string.no_result[$opt_display_lang]}</div>
                      {/if}
                      </div>
                    </div>  
                    {/if}
                  </div>   
                  {else}
                  <div class="cars-display">
                  <div class="form-default edit">
                    <div class="form">
                       <div class="f-inner " style="padding-top: 30px;">
                        <div class="titleHR"><span>{if $opt_display_catalog_name!=''}{$opt_display_catalog_name}{else}{$string.tuningfilesviewer_title[$opt_display_lang]}{/if}</span></div>
                       <h3>{$string.vehicule_type_title_choise[$opt_display_lang]}</h3>
                       <div class="v_type_present">
                          {foreach from=$vehicule_type_list key=ktype item=vtype}
                          <a class='vt-r' href="{$MODULE_INDEX_URL}{$ktype}">
                            <div class='vt-icon {$ktype}'></div>
                            <div class='vt-txt {$ktype}'>{$vtype[$opt_display_lang]}</div>
                          </a>
                          {/foreach}
                        </div>
                      </div>
                    </div>
                  </div>  
                  </div>  
                  {/if} 
                {else}
                <div class="alert alert-danger">{$response.message}</div>
                {/if} 

              {/block}
            </div>
          {/block}
        </div>
      </div>
    </section>

    <footer id="footer">
      {block name="footer"}
        {include file="_partials/footer.tpl"}
      {/block}
    </footer>

  </main>

  {hook h='displayBeforeBodyClosingTag'}

  {block name='javascript_bottom'}
    {include file="_partials/javascript.tpl" javascript=$javascript.bottom}
  {/block}

</body>

</html>