<?php
if (!defined('_PS_VERSION_')) {
  exit;
}
 
class tuningfilescatalog extends Module
{
  public function __construct()
  {
    $this->name                   = 'tuningfilescatalog';
    $this->tab                    = 'front_office_features';
    $this->version                = '1.0.0';
    $this->author                 = 'Mod-files.com';
    $this->need_instance          = 0;
    $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_); 
    $this->bootstrap              = true;
 
    parent::__construct();
 
    $this->displayName = $this->l('Mod-files Tuning Files Catalog');
    $this->description = $this->l('Our database is contaning the power, torque difference between stock and modified gain for every car brand, model, engine, horsepower, when you will put this api in your website you can get same or customed car configuration on your website.');
 
    $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
 
    if (!Configuration::get('TUNINGFILECATALOG_LANG')) {
      $this->warning = $this->l('No lang provided');
    }
  }

  public function install()
  {
    if (Shop::isFeatureActive()) {
      Shop::setContext(Shop::CONTEXT_ALL);
    }
   
    if (!parent::install() ||
      !$this->registerHook('leftColumn') ||
      !$this->registerHook('header') ||
      !$this->registerHook('moduleRoutes') ||
       
      !Configuration::updateValue('TUNINGFILECATALOG_COMPANY_NAME', '') || 
      !Configuration::updateValue('TUNINGFILECATALOG_CATALOG_NAME', '') || 
      !Configuration::updateValue('TUNINGFILECATALOG_API_KEY', '') || 
      !Configuration::updateValue('TUNINGFILECATALOG_API_SECRET', '') || 
      !Configuration::updateValue('TUNINGFILECATALOG_STYLE_BACKGROUND_COLOR', '#FFFFFF') || 
      !Configuration::updateValue('TUNINGFILECATALOG_STYLE_FONT_COLOR', '#333333') || 
      !Configuration::updateValue('TUNINGFILECATALOG_LANG', 'en') || 

      !Configuration::updateValue('TUNINGFILECATALOG_STYLE_MARGIN_TOP', '10') || 
      !Configuration::updateValue('OPTIONS_INTERFACE_DISPLAY_PHOTO', true) || 
      !Configuration::updateValue('OPTIONS_INTERFACE_LONG_DESCRIPTION', true) || 
      !Configuration::updateValue('OPTIONS_INTERFACE_SUB_ITEMS', true) || 
      !Configuration::updateValue('OPTIONS_INTERFACE_CHART', true) 

    ) {
      return false;
    }
   
    return true;
  }
  public function uninstall()
  {
    if (!parent::uninstall() ||
      
      !Configuration::deleteByName('TUNINGFILECATALOG_COMPANY_NAME') || 
      !Configuration::deleteByName('TUNINGFILECATALOG_CATALOG_NAME') || 
      !Configuration::deleteByName('TUNINGFILECATALOG_API_KEY') || 
      !Configuration::deleteByName('TUNINGFILECATALOG_API_SECRET') || 
      !Configuration::deleteByName('TUNINGFILECATALOG_STYLE_BACKGROUND_COLOR') || 
      !Configuration::deleteByName('TUNINGFILECATALOG_STYLE_FONT_COLOR') || 
      !Configuration::deleteByName('TUNINGFILECATALOG_LANG') || 
      
      !Configuration::deleteByName('TUNINGFILECATALOG_STYLE_MARGIN_TOP') || 
      !Configuration::deleteByName('OPTIONS_INTERFACE_DISPLAY_PHOTO') || 
      !Configuration::deleteByName('OPTIONS_INTERFACE_LONG_DESCRIPTION') || 
      !Configuration::deleteByName('OPTIONS_INTERFACE_SUB_ITEMS') || 
      !Configuration::deleteByName('OPTIONS_INTERFACE_CHART') 
    ) {
      return false;
    }
   
    return true;
  }
  public function getContent()
  {
      $output = "<div class='panel'>To access directly to your module, you can visit this page <a href='".Tools::getHttpHost(true).__PS_BASE_URI__."tuning-files/' >".Tools::getHttpHost(true).__PS_BASE_URI__."/tuning-files/</a></div>";

      if (Tools::isSubmit('submit'.$this->name))
      {
          
          $my_module_opt_company_name           = strval(Tools::getValue('TUNINGFILECATALOG_COMPANY_NAME'));
          $my_module_opt_catalog_name           = strval(Tools::getValue('TUNINGFILECATALOG_CATALOG_NAME'));
          $my_module_opt_api_key                = strval(Tools::getValue('TUNINGFILECATALOG_API_KEY'));
          $my_module_opt_api_secret             = strval(Tools::getValue('TUNINGFILECATALOG_API_SECRET'));
          $my_module_opt_lang                   = strval(Tools::getValue('TUNINGFILECATALOG_LANG'));
          $my_module_opt_style_background_color = strval(Tools::getValue('TUNINGFILECATALOG_STYLE_BACKGROUND_COLOR'));
          $my_module_opt_style_font_color       = strval(Tools::getValue('TUNINGFILECATALOG_STYLE_FONT_COLOR'));
          
          $my_module_opt_style_margin_top         = strval(Tools::getValue('TUNINGFILECATALOG_STYLE_MARGIN_TOP'));
          $my_module_opt_display_photo            = strval(Tools::getValue('OPTIONS_INTERFACE_DISPLAY_PHOTO'));
          $my_module_opt_display_long_description = strval(Tools::getValue('OPTIONS_INTERFACE_LONG_DESCRIPTION'));
          $my_module_opt_display_sub_items        = strval(Tools::getValue('OPTIONS_INTERFACE_SUB_ITEMS'));
          $my_module_opt_display_chart            = strval(Tools::getValue('OPTIONS_INTERFACE_CHART'));
          


          if (!$my_module_opt_company_name || empty($my_module_opt_company_name) || !$my_module_opt_api_key || empty($my_module_opt_api_key) || !$my_module_opt_api_secret || empty($my_module_opt_api_secret))
              $output .= $this->displayError($this->l('Invalid Configuration value'));
          else
          {
              
              Configuration::updateValue('TUNINGFILECATALOG_COMPANY_NAME', $my_module_opt_company_name);
              Configuration::updateValue('TUNINGFILECATALOG_CATALOG_NAME', $my_module_opt_catalog_name);
              Configuration::updateValue('TUNINGFILECATALOG_API_KEY', $my_module_opt_api_key);
              Configuration::updateValue('TUNINGFILECATALOG_API_SECRET', $my_module_opt_api_secret);
              Configuration::updateValue('TUNINGFILECATALOG_LANG', $my_module_opt_lang);
              Configuration::updateValue('TUNINGFILECATALOG_STYLE_BACKGROUND_COLOR', $my_module_opt_style_background_color);
              Configuration::updateValue('TUNINGFILECATALOG_STYLE_FONT_COLOR', $my_module_opt_style_font_color);
             
              Configuration::updateValue('TUNINGFILECATALOG_STYLE_MARGIN_TOP', $my_module_opt_style_margin_top);
              Configuration::updateValue('OPTIONS_INTERFACE_DISPLAY_PHOTO', $my_module_opt_display_photo);
              Configuration::updateValue('OPTIONS_INTERFACE_LONG_DESCRIPTION', $my_module_opt_display_long_description);
              Configuration::updateValue('OPTIONS_INTERFACE_SUB_ITEMS', $my_module_opt_display_sub_items);
              Configuration::updateValue('OPTIONS_INTERFACE_CHART', $my_module_opt_display_chart);




              $output .= $this->displayConfirmation($this->l('Settings updated'));
          }
      }
      return $output.$this->displayForm();
  }


  public function displayForm()
  {
      // Get default language
      $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

      // Init Fields form array
      $options_lang = array(
        array( 'id_option' =>'en' , 'name' => "English (United States)" ),
        array( 'id_option' =>'fr' , 'name' => "Français (France)" ),
        array( 'id_option' =>'es' , 'name' => "Español (España)" ),
        array( 'id_option' =>'ru' , 'name' => "русский (Россия)" ),
        array( 'id_option' =>'pt' , 'name' => "Português (Brasil)" ),
        array( 'id_option' =>'it' , 'name' => "Italiano (Italia)" ),
        array( 'id_option' =>'de' , 'name' => "Deutsche (Deutschland)" ),
          
      );

      $fields_form[0]['form'] = array(
          'legend' => array(
              'title' => $this->l('Settings '),
             
          ),
          'input' => array(
              array(
                  'type' => 'text',
                  'label' => $this->l('Company name'),
                  'name' => 'TUNINGFILECATALOG_COMPANY_NAME',
                  'size' => 20,
                  'required' => true
              ),
              array(
                  'type' => 'text',
                  'label' => $this->l('Catalog name')."<span style='font-size: 11px;width: 100%;display: inline-block;'>".$this->l('We have replace tuning files word with your catalog name')."</span>",
                  'name' => 'TUNINGFILECATALOG_CATALOG_NAME',
                  'size' => 20, 
                  'required' => true
              ),
              array(
                  'type' => 'text',
                  'label' => $this->l('Api key'),
                  'name' => 'TUNINGFILECATALOG_API_KEY',
                  'size' => 20,
                  'required' => true
              ),
              array(
                  'type' => 'text',
                  'label' => $this->l('Api key secret'),
                  'name' => 'TUNINGFILECATALOG_API_SECRET',
                  'size' => 20,
                  'required' => true
              ),
              array(
                  'type' => 'color',
                  'label' => $this->l('Background Color'),
                  'name' => 'TUNINGFILECATALOG_STYLE_BACKGROUND_COLOR',
                  'size' => 20,
                  'required' => false
              ),
              array(
                  'type' => 'color',
                  'label' => $this->l('Font Color'),
                  'name' => 'TUNINGFILECATALOG_STYLE_FONT_COLOR',
                  'size' => 20,
                  'required' => false
              ),
              array(
                  'type'     => 'select',
                  'label'    => $this->l('Display Language'),
                  'name'     => 'TUNINGFILECATALOG_LANG',
                  'desc'     => $this->l('Some vehicle information available only in English and French'),
                  'required' => false,
                  'options'  => array(
                    'query' => $options_lang,// $options_lang contains the data itself.
                    'id'    => 'id_option',  // The value of the 'id' key must be the same as the key for 'value' attribute of the <option> tag in each $options_lang sub-array.
                    'name'  => 'name'        // The value of the 'name' key must be the same as the key for the text content of the <option> tag in each $options_lang sub-array.
                  )
              ),
              array(
                  'type' => 'text',
                  'label' => $this->l('Top margin ')."<span style='font-size: 11px;width: 100%;display: inline-block;'>".$this->l('Determine distance from the top of a plugin display to top of window')."</span>",
                  'name' => 'TUNINGFILECATALOG_STYLE_MARGIN_TOP',
                  'size' => 20,
                  'required' => false
              ),
              array(
                'type'    => 'checkbox',                         
                'label'   => $this->l('Options'),                
                'desc'    => $this->l('Customize your interface with the options below'),        
                'name'    => 'OPTIONS_INTERFACE',                          
                'values'  => array(
                  'query' => array(
                      array(
                          'id'   => 'DISPLAY_PHOTO',
                          'name' => $this->l('View a photo of a vehicle'),
                          'val'  => '1',
                      ),
                      array(
                          'id'   => 'LONG_DESCRIPTION',
                          'name' => $this->l('View the long description of a vehicle'),
                          'val'  => '1',
                      ),
                      array(
                          'id'   => 'SUB_ITEMS',
                          'name' => $this->l('Display sub-information (at the bottom of the detail page )'),
                          'val'  => '1',
                      ),
                      array(
                          'id'   => 'CHART',
                          'name' => $this->l('Show the chart of a vehicle'),
                          'val'  => '1',
                      ),
                    ),                           
                  'id'    => 'id',                        
                  'name'  => 'name'                              
                ),
              )
             
          ),
          'submit' => array(
              'title' => $this->l('Save'),
              'class' => 'btn btn-default pull-right'
          )
      );

      

      $helper = new HelperForm();

      // Module, token and currentIndex
      $helper->module = $this;
      $helper->name_controller = $this->name;
      $helper->token = Tools::getAdminTokenLite('AdminModules');
      $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

      // Language
      $helper->default_form_language = $default_lang;
      $helper->allow_employee_form_lang = $default_lang;

      // Title and toolbar
      $helper->title          = $this->displayName;
      $helper->show_toolbar   = true;        // false -> remove toolbar
      $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
      $helper->submit_action  = 'submit'.$this->name;
      $helper->toolbar_btn    = array(
          'save' =>
          array(
              'desc' => $this->l('Save'),
              'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
              '&token='.Tools::getAdminTokenLite('AdminModules'),
          ),
          'back' => array(
              'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
              'desc' => $this->l('Back to list')
          )
      );

      // Load current value
      
      $helper->fields_value['TUNINGFILECATALOG_COMPANY_NAME']           = Configuration::get('TUNINGFILECATALOG_COMPANY_NAME');
      $helper->fields_value['TUNINGFILECATALOG_CATALOG_NAME']           = Configuration::get('TUNINGFILECATALOG_CATALOG_NAME');
      $helper->fields_value['TUNINGFILECATALOG_API_KEY']                = Configuration::get('TUNINGFILECATALOG_API_KEY');
      $helper->fields_value['TUNINGFILECATALOG_API_SECRET']             = Configuration::get('TUNINGFILECATALOG_API_SECRET');
      $helper->fields_value['TUNINGFILECATALOG_LANG']                   = Configuration::get('TUNINGFILECATALOG_LANG');
      $helper->fields_value['TUNINGFILECATALOG_STYLE_BACKGROUND_COLOR'] = Configuration::get('TUNINGFILECATALOG_STYLE_BACKGROUND_COLOR');
      $helper->fields_value['TUNINGFILECATALOG_STYLE_FONT_COLOR']       = Configuration::get('TUNINGFILECATALOG_STYLE_FONT_COLOR');
      
      $helper->fields_value['TUNINGFILECATALOG_STYLE_MARGIN_TOP']       = Configuration::get('TUNINGFILECATALOG_STYLE_MARGIN_TOP');
      $helper->fields_value['OPTIONS_INTERFACE_DISPLAY_PHOTO']          = Configuration::get('OPTIONS_INTERFACE_DISPLAY_PHOTO');
      $helper->fields_value['OPTIONS_INTERFACE_LONG_DESCRIPTION']       = Configuration::get('OPTIONS_INTERFACE_LONG_DESCRIPTION');
      $helper->fields_value['OPTIONS_INTERFACE_SUB_ITEMS']              = Configuration::get('OPTIONS_INTERFACE_SUB_ITEMS');
      $helper->fields_value['OPTIONS_INTERFACE_CHART']                  = Configuration::get('OPTIONS_INTERFACE_CHART');

      return $helper->generateForm($fields_form);
  }

  public function hookDisplayLeftColumn($params)
  {
     
    
  }
     
  public function hookDisplayRightColumn($params)
  {
    return $this->hookDisplayLeftColumn($params);
  }
     
  public function hookDisplayHeader()
  {
    $this->context->controller->addCSS($this->_path.'views/css/tuningfilescatalog.css', 'all');
    $this->context->controller->addJS($this->_path.'views/js/tuningfilescatalog.js');
  }  


  public function hookModuleRoutes() {

    // if (!Configuration::get('PS_REWRITING_SETTINGS'))
    return array(
       /* 'module-tuningfilescatalog-display' => array(
            'controller' => 'display',
            'rule'       => 'tuning-files{/:vehicule_type}{/:mark}{/:model}{/:year}{/:engine}{/:hpower}{/:power}', //the desired page URL contains parameters
            'keywords'   => array( //in the Keywords section we describe every parameter
                'vehicule_type' => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'vehicule_type'),
                'mark'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'mark'),
                'model'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'model'),
                'engine'        => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'engine'),
                'hpower'        => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'hpower'),
                'bhpstandard'   => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'bhpstandard'),
                'fromy'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'fromy'),
                'toy'           => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'toy'),
                'year'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'year'),
                'power'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'power'),
               
            ),
            'params' => array(
                'fc'         => 'module',
                'module'     => 'tuningfilescatalog',
                'controller' => 'display'
            )
        ),*/
        'module-tuningfilescatalog-display1' => array(
            'controller' => 'display',
            'rule'       => 'tuning-files{/:vehicule_type}', //the desired page URL contains parameters
            'keywords'   => array( //in the Keywords section we describe every parameter
                'vehicule_type' => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'vehicule_type'),
                  
            ),
            'params' => array(
                'fc'         => 'module',
                'module'     => 'tuningfilescatalog',
                'controller' => 'display'
            )
        ),
        'module-tuningfilescatalog-display2' => array(
            'controller' => 'display',
            'rule'       => 'tuning-files{/:vehicule_type}{/:mark}', //the desired page URL contains parameters
            'keywords'   => array( //in the Keywords section we describe every parameter
                'vehicule_type' => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'vehicule_type'),
                 'mark'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'mark'),
                 
            ),
            'params' => array(
                'fc'         => 'module',
                'module'     => 'tuningfilescatalog',
                'controller' => 'display'
            )
        ),
        'module-tuningfilescatalog-display3' => array(
            'controller' => 'display',
            'rule'       => 'tuning-files{/:vehicule_type}{/:mark}{/:model}', //the desired page URL contains parameters
            'keywords'   => array( //in the Keywords section we describe every parameter
                'vehicule_type' => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'vehicule_type'),
                 'mark'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'mark'),
                 'model'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'model'),
                
            ),
            'params' => array(
                'fc'         => 'module',
                'module'     => 'tuningfilescatalog',
                'controller' => 'display'
            )
        ),
        'module-tuningfilescatalog-display4' => array(
            'controller' => 'display',
            'rule'       => 'tuning-files{/:vehicule_type}{/:mark}{/:model}{/:year}', //the desired page URL contains parameters
            'keywords'   => array( //in the Keywords section we describe every parameter
                'vehicule_type' => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'vehicule_type'),
                 'mark'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'mark'),
                 'model'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'model'),
                 'year'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'year'),
                 
            ),
            'params' => array(
                'fc'         => 'module',
                'module'     => 'tuningfilescatalog',
                'controller' => 'display'
            )
        ),
        'module-tuningfilescatalog-display5' => array(
            'controller' => 'display',
            'rule'       => 'tuning-files{/:vehicule_type}{/:mark}{/:model}{/:year}{/:engine}', //the desired page URL contains parameters
            'keywords'   => array( //in the Keywords section we describe every parameter
                'vehicule_type' => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'vehicule_type'),
                 'mark'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'mark'),
                 'model'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'model'),
                 'year'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'year'),
                 'engine'        => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'engine'),
                
            ),
            'params' => array(
                'fc'         => 'module',
                'module'     => 'tuningfilescatalog',
                'controller' => 'display'
            )
        ),
        'module-tuningfilescatalog-display6' => array(
            'controller' => 'display',
            'rule'       => 'tuning-files{/:vehicule_type}{/:mark}{/:model}{/:year}{/:engine}{/:hpower}', //the desired page URL contains parameters
            'keywords'   => array( //in the Keywords section we describe every parameter
                'vehicule_type' => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'vehicule_type'),
                 'mark'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'mark'),
                 'model'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'model'),
                 'year'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'year'),
                 'engine'        => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'engine'),
                 'hpower'        => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'hpower'),
                
            ),
            'params' => array(
                'fc'         => 'module',
                'module'     => 'tuningfilescatalog',
                'controller' => 'display'
            )
        ),
        'module-tuningfilescatalog-display7' => array(
            'controller' => 'display',
            'rule'       => 'tuning-files{/:vehicule_type}{/:mark}{/:model}{/:year}{/:engine}{/:hpower}{/:power}', //the desired page URL contains parameters
            'keywords'   => array( //in the Keywords section we describe every parameter
                'vehicule_type' => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'vehicule_type'),
                 'mark'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'mark'),
                 'model'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'model'),
                 'year'          => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'year'),
                 'engine'        => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'engine'),
                 'hpower'        => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'hpower'),
                'power'         => array('regexp' => '[a-zA-ZÀÁÂÃÄÅàáâãäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ0-9\-\_\.\s\(\)\[\]]*', 'param' => 'power'),
               
            ),
            'params' => array(
                'fc'         => 'module',
                'module'     => 'tuningfilescatalog',
                'controller' => 'display'
            )
        ),
    );
  }
}