<?php
/**
* tuningfilescatalogdisplayModuleFrontController
*
* @uses     ModuleFrontController
*
* @category Category
* @package  Package
* @author    <>
* @license  
* @link     
*/
class tuningfilescatalogdisplayModuleFrontController extends ModuleFrontController
{
  

	private $CHIP_API_KEY    = '252222484562';
    private $CHIP_API_SECRET = 's5d8654asdcwklxicmw87powumxcte54';

    public $string = array(
        
        "w_lbl_standard"   => array(
            "de"               => "Standard",
            "en"               => "Standard",
            "es"               => "Estándar",
            "fr"               => "Standard",
            "it"               => "Standard",
            "pt"               => "Padrão",
            "ru"               => "стандарт"
        ),
        "w_lbl_difference" => array(
            "de"               => "Unterschied",
            "en"               => "Difference",
            "es"               => "Diferencia",
            "fr"               => "Différence",
            "it"               => "Differenza",
            "pt"               => "Diferença",
            "ru"               => "разницаs"
        
        ),
        "w_lbl_Torque"     => array(
            "de"               => "Drehmoment",
            "en"               => "Torque",
            "es"               => "Esfuerzo de torsión",
            "fr"               => "Torque",
            "it"               => "momento torcente",
            "pt"               => "Torque",
            "ru"               => "крутящий моментs"
        
        ),
        "w_lbl_Method"     => array(
            "de"               => "Methode",
            "en"               => "Method",
            "es"               => "Método",
            "fr"               => "Méthode",
            "it"               => "Metodo",
            "pt"               => "Método",
            "ru"               => "методs"
        
        ),
        "w_lbl_Options"    => array(
            "de"               => "Optionen",
            "en"               => "Options",
            "es"               => "Opciones",
            "fr"               => "Options",
            "it"               => "Opzioni",
            "pt"               => "Opções",
            "ru"               => "Опции"
        
        ),
        "w_lbl_Options"    => array(
            "de"               => "Tuning-Dateien",
            "en"               => "Tuning Files",
            "es"               => "Sintonización de archivos",
            "fr"               => "Fichiers Tuning",
            "it"               => "Sintonizzazione dei file",
            "pt"               => "Sintonizando arquivos",
            "ru"               => "Настройка файлови"
        
        ),
        "choose_a_mark"    => array(
            "de"               => "Wählen Sie eine Marke ...",
            "en"               => "Choose a brand ...",
            "es"               => "Elija una marca ...",
            "fr"               => "Choisissez une marque ...",
            "it"               => "Scegli una marca ...",
            "pt"               => "Escolha uma marca ...",
            "ru"               => "Выберите бренд ..."
        ),
        "choose_a_model"    => array(
            "de"               => "Wähle ein Modell ...",
            "en"               => "Choose a model ...",
            "es"               => "Escoge un modelo ...",
            "fr"               => "Choisissez un modèle ...",
            "it"               => "Scegli un modello ...",
            "pt"               => "Escolha um modelo ...",
            "ru"               => "Выберите модель ...",     
        ),
        "choose_a_production_year"    => array(
            "de"               => "Wählen Sie ein Baujahr ...",
            "en"               => "Choose a year of construction ...",
            "es"               => "Elegir un año de construcción ...",
            "fr"               => "Choisissez une année de construction ...",
            "it"               => "Scegli un anno di costruzione ...",
            "pt"               => "Escolha um ano de construção ...",
            "ru"               => "Выберите год постройки ..."  
        ),
        "choose_a_engine"    => array(
            "de"               => "Wählen Sie die Art des Motors ...",
            "en"               => "Choose the type of engine ...",
            "es"               => "Elige el tipo de motor ...",
            "fr"               => "Choisissez le type de moteur ...",
            "it"               => "Scegli il tipo di motore ...",
            "pt"               => "Escolha o tipo de motor ...",
            "ru"               => "Выберите тип двигателя ..."
        ),
        "no_result"    => array(
            "de"               => "keine Ergebnisse gefunden",
            "en"               => "No results found",
            "es"               => "No se han encontrado resultados",
            "fr"               => "Aucun résultat trouvé",
            "it"               => "nessun risultato trovato",
            "pt"               => "Nenhum resultado encontrado",
            "ru"               => "результатов не найдено",                          
        ),
        "tuningfilesviewer_title"    => array(
            "de"               => "Tuning-Dateien",
            "en"               => "Tuning Files",
            "es"               => "Sintonización de archivos",
            "fr"               => "Fichiers Tuning",
            "it"               => "Sintonizzazione dei file",
            "pt"               => "Sintonizando arquivos",
            "ru"               => "Настройка файлов"                     
        ),
        "vehicule_type_title_choise"    => array(
            "de"               => "Wählen Sie die Art des Fahrzeugs",
            "en"               => "Choose the type of vehicle",
            "es"               => "Elegir el tipo de vehículo",
            "fr"               => "Choisissez le type de véhicule",
            "it"               => "Scegli il tipo di veicolo",
            "pt"               => "Escolha o tipo de veículo",
            "ru"               => "Выберите тип транспортного средства",
        ),
        "TFV_graph_axeY_name"    => array(
            "de"               => "Leistungssteigerung",
            "en"               => "Power increase",
            "es"               => "Aumento de potencia",
            "fr"               => "Augmentation de la puissance",
            "it"               => "Aumento di potenza",
            "pt"               => "Aumento de potência",
            "ru"               => "Увеличение мощности",                        
        ),
        "fileservice_label_horsepower"    => array(
            "de"               => "Leistung",
            "en"               => "Power",
            "es"               => "Poder",
            "fr"               => "Puissance",
            "it"               => "Energia",
            "pt"               => "Poder",
            "ru"               => "Мощность",           
        ),
        "home"    => array(
            "de"               => "Zuhause",
            "en"               => "Home",
            "es"               => "Casa",
            "fr"               => "Accueil",
            "it"               => "Casa",
            "pt"               => "Casa",
            "ru"               => "Главная" 
        ),
        "up_to"    => array(
            "de"               => "Mehr",
            "en"               => "More than",
            "es"               => "Más de",
            "fr"               => "Plus de ",
            "it"               => "su",
            "pt"               => "Mais",
            "ru"               => "по" 
        ),

    );

 
   


    /**
     * initContent
     * 
     * @access public
     *
     * @return mixed Value.
     */
	public function initContent()
	{
		parent::initContent();



        /** ADMIN OPTIONS  */
        $friendy_url_active                 = Configuration::get('PS_REWRITING_SETTINGS');
        $opt_display_lang                   = Configuration::get('TUNINGFILECATALOG_LANG'); 
        $opt_display_company_name           = Configuration::get('TUNINGFILECATALOG_COMPANY_NAME'); 
        $opt_display_catalog_name           = Configuration::get('TUNINGFILECATALOG_CATALOG_NAME'); 
        $opt_display_api_key                = Configuration::get('TUNINGFILECATALOG_API_KEY'); 
        $opt_display_api_secret             = Configuration::get('TUNINGFILECATALOG_API_SECRET'); 
        $opt_display_style_background_color = Configuration::get('TUNINGFILECATALOG_STYLE_BACKGROUND_COLOR'); 
        $opt_display_style_font_color       = Configuration::get('TUNINGFILECATALOG_STYLE_FONT_COLOR'); 
        
        $opt_display_style_margin_top       = Configuration::get('TUNINGFILECATALOG_STYLE_MARGIN_TOP');
        $opt_display_style_photo            = Configuration::get('OPTIONS_INTERFACE_DISPLAY_PHOTO');
        $opt_display_style_long_description = Configuration::get('OPTIONS_INTERFACE_LONG_DESCRIPTION');
        $opt_display_style_sub_items        = Configuration::get('OPTIONS_INTERFACE_SUB_ITEMS');
        $opt_display_style_chart            = Configuration::get('OPTIONS_INTERFACE_CHART');


        /**
         * CONFIG API */
        $this->CHIP_API_KEY    = $opt_display_api_key;
        $this->CHIP_API_SECRET = $opt_display_api_secret;


        $response            = array('status'=> 'success');
        $meta_title          = $this->string['tuningfilesviewer_title'][$opt_display_lang];
        $expect_display_lang = (isset($opt_display_lang) AND in_array($opt_display_lang, array('fr' , 'en'))) ? $opt_display_lang : 'en' ; 
        
        $WEBROOT             = Tools::getHttpHost(true).__PS_BASE_URI__;
        $MODULE_INDEX_URL    = $WEBROOT . "tuning-files/";
        $show_vehicule_type  = true ;


		// $this->context->smarty->assign('asdasd', $exemple);
        $this->context->smarty->assign(array('friendy_url_active'                 => $friendy_url_active)); 
        $this->context->smarty->assign(array('opt_display_lang'                   => $opt_display_lang)); 
        $this->context->smarty->assign(array('expect_display_lang'                => $expect_display_lang)); 
        $this->context->smarty->assign(array('opt_display_company_name'           => $opt_display_company_name)); 
        $this->context->smarty->assign(array('opt_display_catalog_name'           => $opt_display_catalog_name)); 
        $this->context->smarty->assign(array('opt_display_api_key'                => $opt_display_api_key)); 
        $this->context->smarty->assign(array('opt_display_api_secret'             => $opt_display_api_secret)); 
        $this->context->smarty->assign(array('opt_display_style_background_color' => $opt_display_style_background_color)); 
        $this->context->smarty->assign(array('opt_display_style_font_color'       => $opt_display_style_font_color)); 
        
        $this->context->smarty->assign(array('opt_display_style_margin_top'       => $opt_display_style_margin_top)); 
        $this->context->smarty->assign(array('opt_display_style_photo'            => $opt_display_style_photo)); 
        $this->context->smarty->assign(array('opt_display_style_long_description' => $opt_display_style_long_description)); 
        $this->context->smarty->assign(array('opt_display_style_sub_items'        => $opt_display_style_sub_items)); 
        $this->context->smarty->assign(array('opt_display_style_chart'            => $opt_display_style_chart)); 
        


        $this->context->smarty->assign(array('MODULE_INDEX_URL'                   => $MODULE_INDEX_URL)); 
        $this->context->smarty->assign(array('WEBROOT'                            => $WEBROOT)); 
        $this->context->smarty->assign(array('string'                             => $this->string)); 
        
       
         
       
        $vehicule_type = Tools::getValue('vehicule_type'); $vehicule_type = (isset($vehicule_type) AND $vehicule_type!='') ? $vehicule_type : null;
        $mark          = Tools::getValue('mark');  $mark = (isset($mark) AND $mark!='') ? $mark : null;
        $model         = Tools::getValue('model'); $model = (isset($model) AND $model!='') ? $model : null;
        $engine        = Tools::getValue('engine'); $engine = (isset($engine) AND $engine!='' AND $engine!='-') ? $engine : null;
        $hpower        = Tools::getValue('hpower'); $hpower = (isset($hpower) AND $hpower!='') ? $hpower : null;
        $bhpstandard   = Tools::getValue('bhpstandard'); $bhpstandard = (isset($bhpstandard) AND $bhpstandard!='') ? $bhpstandard : null;
        $fromy         = Tools::getValue('fromy'); $fromy = (isset($fromy) AND $fromy!='') ? $fromy : null;
        $toy           = Tools::getValue('toy'); $toy = (isset($toy) AND $toy!='') ? $toy : null;
        $year          = Tools::getValue('year'); $year = (isset($year) AND $year!='') ? $year : null;
        $power         = Tools::getValue('power'); $power = (isset($power) AND $power!='') ? $power : null;


        $this->context->smarty->assign(array('vehicule_type' => $vehicule_type)); 
        $this->context->smarty->assign(array('mark'          => $mark)); 
        $this->context->smarty->assign(array('model'         => $model)); 
        $this->context->smarty->assign(array('engine'        => $engine)); 
        $this->context->smarty->assign(array('hpower'        => $hpower)); 
        $this->context->smarty->assign(array('bhpstandard'   => $bhpstandard)); 
        $this->context->smarty->assign(array('fromy'         => $fromy)); 
        $this->context->smarty->assign(array('toy'           => $toy)); 
        $this->context->smarty->assign(array('year'          => $year)); 
        $this->context->smarty->assign(array('power'         => $power));


        $preview_list = array('mark'=>false , 'model'=>false , 'year'=>false , 'motor'=>false , 'details'=>false);

        

        if ( isset($mark) AND isset($model)   AND isset($year)    AND ( isset($engine) OR isset($hpower) ) AND isset($power)  ) $preview_list['details'] = true;
        elseif (isset($mark) AND isset($model)  AND isset($year)  ) $preview_list['motor'] = true;
        else if (isset($mark)  AND  isset($model)  ) $preview_list['year'] = true;
        else if (isset($mark)  ) $preview_list['model'] = true;
        else $preview_list['mark'] = true; 


		$this->context->smarty->assign(array('preview_list' => $preview_list)); 
     

        /** Vehicle type list  */
        $vehicule_type_list = $this->tfc_getVechileTypes();
        if ($vehicule_type_list['status']!='0') {
            $response = array('status'=> 'danger' ,  'message'=> $vehicule_type_list['error_text']);
        }else {

            $vehicule_type_list = $this->simplify_vehiculetype_list($vehicule_type_list);

            // Show vehicle type list or more details on a mark 
            if (isset($vehicule_type) AND array_key_exists($vehicule_type, $vehicule_type_list)) $show_vehicule_type = false ;
            $this->context->smarty->assign(array('show_vehicule_type'  => $show_vehicule_type));
            $this->context->smarty->assign(array('vehicule_type_list' => $vehicule_type_list));

          

            /** START */
            if (!$show_vehicule_type):
                if($preview_list['details']):
                    // affiche les details concernant les options qui va fournir pour la voiture ( Augmentation du puissance ) + prix
                    $dataTuningFile_year  = (isset($year)) ?  explode('-', $year) : array(false , false);
                                         
                    $carData = $this->sbs_getCarDetails( array(
                        'vehicule_type' => $vehicule_type,
                        'mark'          => $mark,
                        'model'         => $model,
                        'engine'        => $engine,
                        'hpower'        => $hpower,
                        'yfrom'         => $dataTuningFile_year[0],
                        'yto'           => $dataTuningFile_year[1],
                        'power'         => $power,
                        ));

                    $carData    = (isset($carData) AND !empty($carData)) ? $carData['data'] : null;

                    /** Replace all words of Api company with your company name (if not empty ) */
                    if (isset($opt_display_company_name) AND $opt_display_company_name!='') {

                        $carData[0]['description']['fr'] = (isset($carData[0]['description']['fr']) AND $carData[0]['description']['fr']!='' ) ?  preg_replace("/(Mod-files.com)|(mod-files.com)|(MOD-FILES.COM)|(mod-files)|(Mod-Files.com)/", $opt_display_company_name , $carData[0]['description']['fr']) : '';

                        $carData[0]['description']['en'] = (isset($carData[0]['description']['en']) AND $carData[0]['description']['en']!='' ) ?  preg_replace("/(Mod-files.com)|(mod-files.com)|(MOD-FILES.COM)|(mod-files)|(Mod-Files.com)/", $opt_display_company_name , $carData[0]['description']['en']) : '';
                    
                    }

                    $arrayPoint = (isset($carData[0]['points'][$expect_display_lang]) AND $carData[0]['points'][$expect_display_lang] !='' ) ?  preg_split('/\r\n|[\r\n]/', $carData[0]['points'][$expect_display_lang]) : null;      


                    preg_match('/([0-9]*)/', $carData[0]['hp']['standard'], $output_hp_standard); 
                    preg_match('/([0-9]*)/', $carData[0]['torque']['standard'], $output_torque_standard); 
                    preg_match('/([0-9]*)/', $carData[0]['hp']['system'], $output_hp_system); 
                    preg_match('/([0-9]*)/', $carData[0]['torque']['system'], $output_torque_system); 

                    $this->context->smarty->assign(array('carData'                => $carData)); 
                    $this->context->smarty->assign(array('arrayPoint'             => $arrayPoint)); 
                    $this->context->smarty->assign(array('output_hp_standard'     => $output_hp_standard)); 
                    $this->context->smarty->assign(array('output_torque_standard' => $output_torque_standard)); 
                    $this->context->smarty->assign(array('output_hp_system'       => $output_hp_system)); 
                    $this->context->smarty->assign(array('output_torque_system'   => $output_torque_system)); 


                    $motorsList = $this->sbs_getMotors( array(
                        'vehicule_type' => $vehicule_type,
                        'mark'          => $mark,
                        'model'         => $model,
                        'yfrom'         => $dataTuningFile_year[0],
                        'yto'           => $dataTuningFile_year[1],
                        ));

                    
                    $motorsList = $motorsList['data'];  
                    $this->context->smarty->assign(array('motorsList'    => $motorsList)); 


                    $modellist = $this->sbs_getmodels( array(
                            'vehicule_type' => $vehicule_type,
                            'mark'          => $mark,
                            ));
                      
                    $modellist = $modellist['data'];
                    $this->context->smarty->assign(array('modellist'    => $modellist)); 


                    $productionYearList = $this->sbs_getProductionYear( array(
                            'vehicule_type' => $vehicule_type,
                            'mark'          => $mark,
                            'model'         => $model,
                            ));

                    $productionYearList = $productionYearList['data'];
                    $this->context->smarty->assign(array('productionYearList' => $productionYearList)); 

                    /** GENERATE PAGE TITLE */
                    $meta_title =   $carData[0]['mark']['name']." ".$carData[0]['model']['name']." ".$carData[0]['horsepower']['name']." ".((isset($carData[0]['engine']['name']) AND $carData[0]['engine']['name']!='') ? $carData[0]['engine']['name'] : '' )." ".$carData[0]['hp']['standard']." | ".$this->string['tuningfilesviewer_title'][$opt_display_lang];

                elseif ($preview_list['motor'] OR $preview_list['year'] OR $preview_list['model']):

                    if ( $preview_list['model'] OR $preview_list['year'] OR $preview_list['motor']):

                        $modellist = $this->sbs_getmodels( array(
                            'vehicule_type' => $vehicule_type,
                            'mark'          => $mark,
                            ));
                          
                        $modellist = $modellist['data'];
                        $this->context->smarty->assign(array('modellist'    => $modellist)); 
                    endif; 

                    if ( $preview_list['year'] OR $preview_list['motor']):

                        $productionYearList = $this->sbs_getProductionYear( array(
                            'vehicule_type' => $vehicule_type,
                            'mark'          => $mark,
                            'model'         => $model,
                            ));

                        $productionYearList = $productionYearList['data'];
                        $this->context->smarty->assign(array('productionYearList' => $productionYearList)); 
                    endif;

                    if ($preview_list['motor']):


                        $dataTuningFile_year  = explode('-', $year);
                                             
                        $motorsList = $this->sbs_getMotors( array(
                            'vehicule_type' => $vehicule_type,
                            'mark'          => $mark,
                            'model'         => $model,
                            'yfrom'         => $dataTuningFile_year[0],
                            'yto'           => $dataTuningFile_year[1],
                            ));

                        
                        $motorsList = $motorsList['data'];  
                        $this->context->smarty->assign(array('motorsList'    => $motorsList)); 
                    endif;
                else: // affiche la liste des marques
                    $markList = $this->sbs_getMarks( array(
                        'vehicule_type' => $vehicule_type
                        ));

                    $this->context->smarty->assign(array('markList'    => $markList));
                   
                endif;
            else:

            endif;
        }

    
        /** GENERAL DISPATCHER VARIABLE */
        $this->context->smarty->assign(array('meta_title' => $meta_title)); 
        $this->context->smarty->assign(array('response'   => $response)); 

		if (_PS_VERSION_ >= '1.7.0.0') {
		    $this->setTemplate('module:tuningfilescatalog/views/templates/front/display.tpl');
		} else {
		    $this->setTemplate('display.tpl');
		}
	 
	}


    
    public function simplify_vehiculetype_list($tab = array()){

        
        if (!isset($tab) OR empty($tab)) return false;

        $response = array();
        foreach ($tab['data'] as $key => $value) {
            $response[$value['type']['id']] = $value['type']['name'];
        }

        return $response;

    }
    /**
     * tfc_getVechileTypes
     * 
     * @access public
     *
     * @return mixed Value.
     */
    public function tfc_getVechileTypes(){

        

            $url = 'https://www.mod-files.com/api/chip/v1/types?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'sort'       => 'type',
            ]);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            error_log($response);
            return json_decode($response , true);
 
            


            
        
        return false;


    }


    /**
     * sbs_getMarks
     * 
     * @param array $data Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
  	public function sbs_getMarks($data = array()){

        if (isset($data['vehicule_type']) AND $data['vehicule_type']!=''){

            $url = 'https://www.mod-files.com/api/chip/v1/types/'.$data['vehicule_type'].'/marks?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'logo',
                'sort'       => 'mark',
            ]);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            error_log($response);
            return json_decode($response , true);

           return $response;


            
        }
        return false;


    }

    /**
     * sbs_getModels
     * 
     * @param array $data Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
    public function sbs_getModels($data = array()){

        $_link_adapter = "";
        if (isset($data['vehicule_type']) AND $data['vehicule_type']!='') $_link_adapter .= "types/".$data['vehicule_type']."/";
        if (isset($data['mark']) AND $data['mark']!='') $_link_adapter .= "marks/".$data['mark']."/";

            $url = 'https://www.mod-files.com/api/chip/v1/'.$_link_adapter.'models?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'logo,mark,model',
                 'sort'       => 'model',
            ]);

            

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            // error_log($response);

            return json_decode($response , true);

       
        return false;


    }

    /**
     * sbs_getProductionYear
     * 
     * @param array $data Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
    public function sbs_getProductionYear($data = array()){

        $_link_adapter = "";
        if (isset($data['vehicule_type']) AND $data['vehicule_type']!='') $_link_adapter .= "types/".$data['vehicule_type']."/";
        if (isset($data['mark']) AND $data['mark']!='') $_link_adapter .= "marks/".$data['mark']."/";
        if (isset($data['model']) AND $data['model']!='') $_link_adapter .= "models/".$data['model']."/";

            $url = 'https://www.mod-files.com/api/chip/v1/'.$_link_adapter.'yfrom?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'logo,mark,model,model_type',
                'sort'     => 'production_start_year',
            ]);

            

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            // error_log($response);

            return json_decode($response , true);

       
        return false;


    }
    public function sbs_getMotors($data = array()){

        $_link_adapter = "";
        $sort          ="";

        if (isset($data['vehicule_type']) AND $data['vehicule_type']!='') { $_link_adapter .= "types/".$data['vehicule_type']."/";   }
        if (isset($data['mark']) AND $data['mark']!='') { $_link_adapter .= "marks/".$data['mark']."/"; $sort ="mark"; }
        if (isset($data['model']) AND $data['model']!='') { $_link_adapter .= "models/".$data['model']."/"; $sort ="model"; }
        if (isset($data['yfrom']) AND $data['yfrom']!='') { $_link_adapter .= "yfrom/".$data['yfrom']."/"; $sort ="production_start_year"; }
        if (isset($data['yto']) AND $data['yto']!='') { $_link_adapter .= "yto/".$data['yto']."/"; $sort ="production_end_year"; }

            $url = 'https://www.mod-files.com/api/chip/v1/'.$_link_adapter.'?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'logo,mark,model,engine,horsepower,hp',
                'sort'       => $sort
            ]);

           // echo $url;  

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            // error_log($response);

            return json_decode($response , true);

       
        return false;


    }


    /**
     * sbs_getCarDetails
     * 
     * @param array $data Description.
     *
     * @access public
     *
     * @return mixed Value.
     */
    public function sbs_getCarDetails($data = array()){

        $_link_adapter = "";
        if (isset($data['vehicule_type']) AND $data['vehicule_type'] !='') $_link_adapter .= "types/".$data['vehicule_type']."/";
        if (isset($data['mark']) AND $data['mark']                   !='') $_link_adapter .= "marks/".$data['mark']."/";
        if (isset($data['model']) AND $data['model']                 !='') $_link_adapter .= "models/".$data['model']."/";
        if (isset($data['yfrom']) AND $data['yfrom']                 !='') $_link_adapter .= "yfrom/".$data['yfrom']."/";
        if (isset($data['yto']) AND $data['yto']                     !='') $_link_adapter .= "yto/".$data['yto']."/";
        if (isset($data['engine']) AND $data['engine']               !='') $_link_adapter .= "engines/".$data['engine']."/";
        if (isset($data['horsepower']) AND $data['horsepower']       !='') $_link_adapter .= "horsepowers/".$data['horsepower']."/";
        if (isset($data['power']) AND $data['power']                 !='') $_link_adapter .= "powers/".$data['power']."/";

            $url = 'https://www.mod-files.com/api/chip/v1/'.$_link_adapter.'?' . http_build_query([
                'api_key'    => $this->CHIP_API_KEY,
                'api_secret' => $this->CHIP_API_SECRET,
                'fields'     => 'logo,mark,model,engine,horsepower,hp,torque,description,points,method,options,image',
            ]);

           

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, 0);
            $response = curl_exec($ch);
            // error_log($response);

            return json_decode($response , true);

       
        return false;


    }


}